/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SyntaxUsage;
import org.refcodes.cli.Syntaxable;

public abstract class AbstractCondition
extends AbstractSyntaxable
implements Condition {
    private List<Syntaxable> _children = new ArrayList<Syntaxable>();

    public AbstractCondition(Syntaxable ... aElements) {
        this._children.addAll(Arrays.asList(aElements));
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder(this.toUsage(aSyntaxNotation, aOptionEscCode, aResetEscCode));
        if (theBuilder.length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            theBuilder.insert(0, "( ");
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }

    public void reset() {
        for (Syntaxable eSyntaxable : this._children) {
            eSyntaxable.reset();
        }
    }

    public String toString() {
        String theState = this.toState();
        if (theState != null && theState.length() >= 4 && theState.startsWith("( ") && theState.endsWith(" )")) {
            theState = theState.substring(2).substring(0, theState.length() - 4);
        }
        return theState;
    }

    public List<Operand<?>> toOperands() {
        ArrayList theList = new ArrayList();
        for (SyntaxUsage syntaxUsage : this.getChildren()) {
            if (syntaxUsage instanceof Operand) {
                theList.add((Operand)syntaxUsage);
            }
            if (!(syntaxUsage instanceof Condition)) continue;
            theList.addAll(((Condition)syntaxUsage).toOperands());
        }
        return theList;
    }

    protected List<Syntaxable> getChildren() {
        return this._children;
    }

    protected void addChild(Syntaxable aArgumentizer) {
        this._children.add(aArgumentizer);
    }

    @Override
    public <V> V get(String aAlias) {
        for (Syntaxable eElement : this._children) {
            Object eValue = eElement.get(aAlias);
            if (eValue == null) continue;
            return eValue;
        }
        return null;
    }
}

