/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.jansi.AnsiConsole;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.ExampleUsage;
import org.refcodes.cli.Flag;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.OptionConditionFacade;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Delimiter;
import org.refcodes.data.License;
import org.refcodes.data.Literal;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Terminal;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.Relation;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserImpl
implements ArgsParser {
    private List<ExampleUsage> _exampleUsages = null;
    private Font _bannerFont = new FontImpl(FontFamily.DIALOG, FontStyle.PLAIN, 12);
    private char[] _bannerFontPalette = AsciiColorPalette.HALFTONE_GRAY.getPalette();
    private Condition _rootCondition;
    private SyntaxNotation _syntaxNotation = SyntaxNotation.REFCODES;
    private int _consoleWidth = Terminal.toPreferredTerminalWidth();
    private int _maxConsoleWidth = -1;
    private String _lineBreak = Terminal.getLineBreak();
    private String _title = null;
    private String _name = "foobar";
    private String _description = "See the syntax declaration for usage, see the descriptions for the short- and the long-options. Option arguments are noted in angle brackets.";
    private String _usageLabel = "Usage";
    private String _licenseNote = License.LICENSE_NOTE.getText();
    private String _copyrightNote = License.COPYRIGHT_NOTE.getText();
    private boolean _isEscCodesEnabled = Terminal.isAnsiTerminalPreferred();
    private String _resetEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private String _paramEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _descriptionEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR});
    private String _bannerEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _bannerBorderEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private String _lineSeparatorEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private TextBoxGrid _textBoxGrid = TextBoxStyle.toRuntimeTextBoxStyle().getTextBoxGrid();
    private char _separatorLnChar = ((Character)this._textBoxGrid.getInnerLine()).charValue();
    private boolean _hasOverrideSeparatorLnChar = false;
    protected PrintStream _stdStream = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !RuntimeUtility.isUnderTest() ? AnsiConsole.out() : System.out;
    protected PrintStream _errStream = OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !RuntimeUtility.isUnderTest() ? AnsiConsole.err() : System.err;

    public ArgsParserImpl() {
        this._rootCondition = null;
    }

    public ArgsParserImpl(Condition aRootCondition) {
        this._rootCondition = aRootCondition;
    }

    public ArgsParserImpl(Option<?> aRootOption) {
        this._rootCondition = new OptionConditionFacade((Syntaxable)aRootOption);
    }

    @Override
    public String getLineSeparatorEscapeCode() {
        return this._lineSeparatorEscCode;
    }

    @Override
    public void setLineSeparatorEscapeCode(String aLineSeparatorEscCode) {
        this._lineSeparatorEscCode = aLineSeparatorEscCode;
    }

    @Override
    public String getBannerEscapeCode() {
        return this._bannerEscCode;
    }

    @Override
    public String getBannerBorderEscapeCode() {
        return this._bannerBorderEscCode;
    }

    @Override
    public void setBannerEscapeCode(String aBannerEscCode) {
        this._bannerEscCode = aBannerEscCode;
    }

    @Override
    public void setBannerBorderEscapeCode(String aBannerBorderEscCode) {
        this._bannerBorderEscCode = aBannerBorderEscCode;
    }

    @Override
    public String getParameterEscapeCode() {
        return this._paramEscCode;
    }

    @Override
    public void setParameterEscapeCode(String aParamEscCode) {
        this._paramEscCode = aParamEscCode;
    }

    @Override
    public void errorLn(String aLine) {
        if (aLine == null) {
            aLine = "null";
        }
        String[] theLines = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{aLine})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._errStream.print(this.fromTextBlock(theLines, this.toLineBreak()));
        this._errStream.flush();
    }

    @Override
    public List<? extends Operand<?>> evalArgs(String[] aArgs) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        if (this._rootCondition == null) {
            return ArgsParserImpl.fromArgs(aArgs, this.getDelimiter());
        }
        List<? extends Operand<?>> theOperands = this._rootCondition.parseArgs(aArgs);
        Object[] theSuperflousArgs = CliUtility.toDiff(aArgs, theOperands);
        if (theSuperflousArgs != null && theSuperflousArgs.length > 0) {
            throw new SuperfluousArgsException((String[])theSuperflousArgs, "Superfluous command arguments " + new VerboseTextBuilder().withElements(theSuperflousArgs).toString() + " were provided but cannot be evaluated or are not supported as of the given combination of arguments.");
        }
        return theOperands;
    }

    private String fromTextBlock(String[] aTextBlock, String aDelimeter) {
        StringBuilder theBuilder = new StringBuilder();
        String[] stringArray = aTextBlock;
        int n = aTextBlock.length;
        int n2 = 0;
        while (n2 < n) {
            String eString = stringArray[n2];
            if (aDelimeter != null && aDelimeter.length() != 0 && theBuilder.length() > 0) {
                theBuilder.append(aDelimeter);
            }
            theBuilder.append(eString);
            ++n2;
        }
        return String.valueOf(theBuilder.toString()) + this.toLineBreak();
    }

    @Override
    public String getCopyrightNote() {
        return this._copyrightNote;
    }

    protected char getDelimiter() {
        return Delimiter.INDEX.getChar();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getLicenseNote() {
        return this._licenseNote;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Condition getRootCondition() {
        return this._rootCondition;
    }

    public String getResetEscapeCode() {
        return this._resetEscCode;
    }

    public void setResetEscapeCode(String aResetEscCode) {
        this._resetEscCode = aResetEscCode;
    }

    public String getTitle() {
        return this._title;
    }

    @Override
    public void printBanner() {
        int theBannerWidth = this._consoleWidth - 4;
        String[] theCanvas = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(theBannerWidth).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        boolean hasBorder = this.hasBorder(theCanvas);
        if (hasBorder) {
            theBannerWidth = this._consoleWidth - 2;
            theCanvas = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(theBannerWidth).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        }
        theCanvas = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(theCanvas)).withColumnWidth(theBannerWidth).withFillChar(' ').toStrings();
        if (!hasBorder) {
            theCanvas = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(theCanvas)).withBorderWidth(1).withBorderChar(' ').toStrings();
        }
        theCanvas = ((TextBorderBuilder)new TextBorderBuilder().withTextBoxGrid(this._textBoxGrid).withText(theCanvas)).withBoxBorderMode(BoxBorderMode.ALL).toStrings();
        if (this._isEscCodesEnabled) {
            theCanvas[0] = String.valueOf(this._bannerBorderEscCode) + theCanvas[0] + this._resetEscCode;
            if (theCanvas.length > 1) {
                int i = 1;
                while (i < theCanvas.length - 1) {
                    theCanvas[i] = String.valueOf(this._bannerBorderEscCode) + theCanvas[i].substring(0, 1) + this._resetEscCode + this._bannerEscCode + theCanvas[i].substring(1, theCanvas[i].length() - 1) + this._resetEscCode + this._bannerBorderEscCode + theCanvas[i].substring(theCanvas[i].length() - 1) + this._resetEscCode;
                    ++i;
                }
            }
            theCanvas[theCanvas.length - 1] = String.valueOf(this._bannerBorderEscCode) + theCanvas[theCanvas.length - 1] + this._resetEscCode;
        }
        this._stdStream.print(this.fromTextBlock(theCanvas, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printCopyrightNote() {
        this._stdStream.println(this._copyrightNote);
        this._stdStream.flush();
    }

    @Override
    public void printDescription() {
        this._stdStream.println(String.valueOf(this._isEscCodesEnabled ? this._descriptionEscCode : "") + this._description + (this._isEscCodesEnabled ? this._resetEscCode : ""));
        this._stdStream.flush();
    }

    @Override
    public void printLicenseNote() {
        this._stdStream.println(this._licenseNote);
        this._stdStream.flush();
    }

    @Override
    public void printLn() {
        this._stdStream.println();
        this._stdStream.flush();
    }

    @Override
    public void printLn(String aLine) {
        String[] theLines = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{aLine})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._stdStream.print(this.fromTextBlock(theLines, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printOptions() {
        if (this._rootCondition != null) {
            List<Operand<?>> theOperands = this._rootCondition.toOperands();
            HashMap<String, String[]> theOptArgs = new HashMap<String, String[]>();
            int theMaxLength = 0;
            for (Operand<?> eOperand : theOperands) {
                String eOpt = CliUtility.toSpec(eOperand);
                if (eOpt.length() > theMaxLength) {
                    theMaxLength = eOpt.length();
                }
                theOptArgs.put(eOpt, new String[]{eOpt, ":", " ", eOperand.getDescription()});
            }
            TableBuilder theOptTable = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            if (this._isEscCodesEnabled) {
                theOptTable.setResetEscapeCode(this._resetEscCode);
                theOptTable.setEscapeCodesEnabled(true);
            }
            theOptTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(theMaxLength, ColumnWidthType.ABSOLUTE);
            if (this._isEscCodesEnabled) {
                theOptTable.withRowColumnEscapeCode(this._paramEscCode);
            }
            theOptTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theOptTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theOptTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            if (this._isEscCodesEnabled) {
                theOptTable.withRowColumnEscapeCode(this._descriptionEscCode);
            }
            theOptTable.withLineBreak(this.toLineBreak());
            ArrayList theKeys = new ArrayList(theOptArgs.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                theOptTable.printRowContinue((String[])theOptArgs.get(eKey));
            }
        }
    }

    @Override
    public void printExampleUsages() {
        if (this._exampleUsages != null && this._exampleUsages.size() != 0) {
            int theMaxLength = 0;
            for (ExampleUsage eUsage : this._exampleUsages) {
                String eDescription = eUsage._description;
                if (eDescription.length() <= theMaxLength) continue;
                theMaxLength = eDescription.length();
            }
            if (theMaxLength > this._consoleWidth / 2 && (theMaxLength = this._consoleWidth / 2) < ConsoleDimension.MIN_WIDTH.getValue() / 2) {
                theMaxLength = ConsoleDimension.MIN_WIDTH.getValue() / 2;
            }
            TableBuilder theUsageTable = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            if (this._isEscCodesEnabled) {
                theUsageTable.setEscapeCodesEnabled(true);
                theUsageTable.setResetEscapeCode(this._resetEscCode);
            }
            theUsageTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(theMaxLength, ColumnWidthType.ABSOLUTE);
            if (this._isEscCodesEnabled) {
                theUsageTable.withRowColumnEscapeCode(this._descriptionEscCode);
            }
            theUsageTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theUsageTable.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            theUsageTable.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            theUsageTable.withLineBreak(this.toLineBreak());
            for (ExampleUsage eUsage : this._exampleUsages) {
                String eArgs = "\"" + this.getName() + this._paramEscCode;
                Operand<?>[] operandArray = eUsage.getOperands();
                int n = operandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Operand<?> eOperand = operandArray[n2];
                    eArgs = String.valueOf(eArgs) + " ";
                    if (eOperand instanceof Flag) {
                        Flag eFlag = (Flag)eOperand;
                        eArgs = String.valueOf(eArgs) + (eFlag.getShortOption() != null ? eFlag.getShortOption() : eFlag.getLongOption());
                    } else if (eOperand instanceof Option) {
                        Option eOption = (Option)eOperand;
                        eArgs = String.valueOf(eArgs) + (eOption.getShortOption() != null ? eOption.getShortOption() : eOption.getLongOption());
                        eArgs = String.valueOf(eArgs) + " <" + (eOption.getAlias() != null ? eOption.getAlias() : eOption.getType().getSimpleName()) + ">";
                    } else {
                        eArgs = String.valueOf(eArgs) + " <" + (eOperand.getAlias() != null ? eOperand.getAlias() : eOperand.getType().getSimpleName()) + ">";
                    }
                    ++n2;
                }
                eArgs = String.valueOf(eArgs) + this._resetEscCode + "\"";
                theUsageTable.printRowContinue(new String[]{eUsage.getDescription(), ":", " ", eArgs});
            }
        }
    }

    @Override
    public void printSeparatorLn() {
        String theLine = String.valueOf(new TextLineBuilder().withColumnWidth(this._consoleWidth).withLineChar(this._separatorLnChar).toString()) + this.toLineBreak();
        if (this._isEscCodesEnabled) {
            theLine = String.valueOf(this._lineSeparatorEscCode) + theLine + this._resetEscCode;
        }
        this._stdStream.print(theLine);
        this._stdStream.flush();
    }

    @Override
    public void printUsage() {
        String theUsage = this._rootCondition != null ? (this._isEscCodesEnabled ? this._rootCondition.toUsage(this._syntaxNotation, this._paramEscCode, this._resetEscCode) : this._rootCondition.toUsage(this._syntaxNotation)) : "<?>";
        String theSyntax = String.valueOf(this._usageLabel) + ": " + this._name + " " + theUsage;
        this._stdStream.println(theSyntax);
        this._stdStream.flush();
    }

    public void reset() {
        if (this._rootCondition != null) {
            this._rootCondition.reset();
        }
    }

    @Override
    public void setBannerFont(Font aBannerFont) {
        this._bannerFont = aBannerFont;
    }

    @Override
    public void setBannerFontPalette(char[] aColorPalette) {
        this._bannerFontPalette = aColorPalette;
    }

    @Override
    public void setConsoleWidth(int aConsoleWidth) {
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < aConsoleWidth ? this._maxConsoleWidth : aConsoleWidth) : aConsoleWidth;
    }

    @Override
    public void setCopyrightNote(String aCopyrightNote) {
        this._copyrightNote = aCopyrightNote;
    }

    public void setDescription(String aDescription) {
        this._description = aDescription;
    }

    @Override
    public void setErrorOut(PrintStream aErrorOut) {
        this._errStream = aErrorOut;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscCodesEnabled;
    }

    public void setEscapeCodesEnabled(boolean isEscCodeEnabled) {
        this._isEscCodesEnabled = isEscCodeEnabled;
    }

    @Override
    public String getDescriptionEscapeCode() {
        return this._descriptionEscCode;
    }

    @Override
    public void setDescriptionEscapeCode(String aDescriptionEscCode) {
        this._descriptionEscCode = aDescriptionEscCode;
    }

    @Override
    public void setLicenseNote(String aLicenseNote) {
        this._licenseNote = aLicenseNote;
    }

    @Override
    public void setLineBreak(String aLineBreak) {
        if (aLineBreak == null) {
            aLineBreak = Terminal.getLineBreak();
        }
        this._lineBreak = aLineBreak;
    }

    @Override
    public void setMaxConsoleWidth(int aMaxConsoleWidth) {
        this._maxConsoleWidth = aMaxConsoleWidth;
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < this._consoleWidth ? this._maxConsoleWidth : this._consoleWidth) : this._consoleWidth;
    }

    public void setName(String aName) {
        this._name = aName;
    }

    @Override
    public void setSeparatorLnChar(char aSeparatorLnChar) {
        this._separatorLnChar = aSeparatorLnChar;
        this._hasOverrideSeparatorLnChar = true;
    }

    @Override
    public char getSeparatorLnChar() {
        return this._separatorLnChar;
    }

    @Override
    public void setStandardOut(PrintStream aStandardOut) {
        this._stdStream = aStandardOut;
    }

    @Override
    public void setSyntaxNotation(SyntaxNotation aSyntaxNotation) {
        this._syntaxNotation = aSyntaxNotation;
    }

    public void setTitle(String aTitle) {
        this._title = aTitle;
    }

    @Override
    public void setUsageLabel(String aUsageLabel) {
        this._usageLabel = aUsageLabel;
    }

    public TextBoxGrid getTextBoxGrid() {
        return this._textBoxGrid;
    }

    public void setTextBoxGrid(TextBoxGrid aTextBoxGrid) {
        this._textBoxGrid = aTextBoxGrid;
        if (!this._hasOverrideSeparatorLnChar) {
            this._separatorLnChar = ((Character)aTextBoxGrid.getInnerLine()).charValue();
        }
    }

    @Override
    public List<ExampleUsage> getExampleUsages() {
        return this._exampleUsages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExampleUsage(String aDescription, Operand<?> ... aOperands) {
        if (this._exampleUsages == null) {
            ArgsParserImpl argsParserImpl = this;
            synchronized (argsParserImpl) {
                if (this._exampleUsages == null) {
                    this._exampleUsages = new ArrayList<ExampleUsage>();
                }
            }
        }
        this._exampleUsages.add(new ExampleUsage(aDescription, aOperands));
    }

    protected static List<? extends Operand<?>> fromArgs(String[] aArgs, char aDelimiter) {
        ArrayList<AbstractOperand> theOperands = new ArrayList<AbstractOperand>();
        Map theArgs = RuntimeUtility.toProperties((String[])aArgs, (String[])CommandArgPrefix.toPrefixes(), (char)aDelimiter);
        for (String eKey : theArgs.keySet()) {
            if (Literal.TRUE.getValue().equalsIgnoreCase((String)theArgs.get(eKey))) {
                theOperands.add(new Flag(eKey, true));
                continue;
            }
            theOperands.add(new StringOperand((Relation<String, String>)new PropertyImpl(eKey, (String)theArgs.get(eKey))));
        }
        return theOperands;
    }

    private String toLineBreak() {
        if (Terminal.isLineBreakRequired((int)this._consoleWidth)) {
            return this._lineBreak;
        }
        return "";
    }

    private boolean hasBorder(String[] aCanvas) {
        if (aCanvas != null && aCanvas.length != 0) {
            char ePrevChar = aCanvas[0].length() != 0 ? (char)aCanvas[0].charAt(0) : (char)' ';
            int i = 0;
            while (i < aCanvas[0].length()) {
                if (ePrevChar != aCanvas[0].charAt(i)) {
                    return false;
                }
                ePrevChar = aCanvas[0].charAt(i);
                ++i;
            }
            i = 0;
            while (i < aCanvas[aCanvas.length - 1].length()) {
                if (ePrevChar != aCanvas[aCanvas.length - 1].charAt(i)) {
                    return false;
                }
                ePrevChar = aCanvas[aCanvas.length - 1].charAt(i);
                ++i;
            }
            i = 0;
            while (i < aCanvas.length) {
                if (ePrevChar != aCanvas[i].charAt(0)) {
                    return false;
                }
                ePrevChar = aCanvas[i].charAt(0);
                ++i;
            }
            i = 0;
            while (i < aCanvas.length) {
                if (ePrevChar != aCanvas[i].charAt(aCanvas[i].length() - 1)) {
                    return false;
                }
                ePrevChar = aCanvas[i].charAt(aCanvas[i].length() - 1);
                ++i;
            }
        }
        return true;
    }
}

