/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;

public class ArrayOperand<T>
extends AbstractSyntaxable
implements Operand<T[]> {
    private Operand<T> _operand;
    private T[] _values = null;
    private int _minLength;
    private int _maxLength;
    private Class<T[]> _type;

    public ArrayOperand(Operand<T> aOperand) {
        this(aOperand, -1, -1);
    }

    public ArrayOperand(Operand<T> aOperand, int aLength) {
        this(aOperand, aLength, aLength);
    }

    public ArrayOperand(Operand<T> aOperand, int aMinLength, int aMaxLength) {
        if (aMaxLength == 0 || aMinLength != -1 && aMaxLength != -1 && aMinLength > aMaxLength || aMaxLength < -1 || aMaxLength < -1) {
            throw new IllegalArgumentException("The minimum length <" + aMinLength + "> must be less or equal than the maximum length <" + aMaxLength + ">, both values must be greater (minimum and maximum) or equal (minimum) than <0> (or <-1> when to be ignored)!");
        }
        this._operand = aOperand;
        this._minLength = aMinLength;
        this._maxLength = aMaxLength;
        this._type = Array.newInstance(aOperand.getType(), 0).getClass();
    }

    @Override
    public T[] getValue() {
        return this._values;
    }

    @Override
    public String[] getArgs() {
        return this._operand.getArgs();
    }

    @Override
    public String getAlias() {
        return this._operand.getAlias();
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        aOptionEscCode = aOptionEscCode == null ? "" : aOptionEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        return String.valueOf(aOptionEscCode) + CliUtility.toParameterSpec(this, this._minLength, this._maxLength) + aResetEscCode;
    }

    public Class<T[]> getType() {
        return this._type;
    }

    public List<Operand<?>> parseArgs(String[] aArgs, String[] aOperands) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        int index;
        ArrayList theOperands;
        ArrayList<T> theValues;
        block7: {
            theValues = new ArrayList<T>();
            theOperands = new ArrayList();
            index = 0;
            try {
                while (this._maxLength == -1 || index < this._maxLength) {
                    List eOperands = this._operand.parseArgs(aArgs, aOperands);
                    for (Operand eOperand : eOperands) {
                        Object eObj;
                        try {
                            eObj = eOperand.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new ParseArgsException(aArgs, "The type <" + this._operand.getType().getSimpleName() + "> does not support cloning: " + e.getMessage(), e);
                        }
                        theOperands.add((Operand)eObj);
                    }
                    theValues.add(this._operand.getValue());
                    aArgs = CliUtility.toDiff(aArgs, eOperands);
                    ++index;
                }
            }
            catch (AmbiguousArgsException | ParseArgsException | UnknownArgsException e) {
                if (this._maxLength == -1 || index <= this._maxLength) break block7;
                throw e;
            }
        }
        if (this._minLength != -1 && index < this._minLength) {
            throw new UnknownArgsException(aArgs, "Not one argument matched (as of \"" + CliUtility.toSpec(this) + "\")");
        }
        this._values = theValues.toArray((Object[])Array.newInstance(this._operand.getType(), theValues.size()));
        return theOperands;
    }

    @Override
    public String toState() {
        return this._operand.toState();
    }

    public void reset() {
        this._operand.reset();
        this._values = null;
    }

    public String getDescription() {
        return this._operand.getDescription();
    }

    @Override
    public int compareTo(Operand<?> o) {
        return this._operand.compareTo(o);
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected Operand<T> getOperand() {
        return this._operand;
    }
}

