/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.mixin.EnabledAccessor;

public class Operation
extends AbstractOperand<Boolean>
implements EnabledAccessor {
    private String _operation;

    public Operation(String aOperation, String aAlias, String aDescription) {
        super(Boolean.class, aAlias, aDescription);
        if (aOperation == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        if (aOperation.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()) | aOperation.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + aOperation + "\" must not start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._operation = aOperation;
    }

    public Operation(String aOperation, String aDescription) {
        super(Boolean.class, null, aDescription);
        if (aOperation == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        if (aOperation.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()) | aOperation.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + aOperation + "\" must not start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._operation = aOperation;
    }

    @Override
    public List<Operand<Boolean>> parseArgs(String[] aArgs, String[] aOptions) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        boolean hasOperation;
        block4: {
            if (aArgs != null) {
                int i = 0;
                while (i < aArgs.length) {
                    if (this.getOperation().equals(aArgs[i])) {
                        hasOperation = true;
                        break block4;
                    }
                    ++i;
                }
            }
            hasOperation = false;
        }
        if (hasOperation) {
            ArrayList<Operand<Boolean>> theList = new ArrayList<Operand<Boolean>>();
            theList.add(this);
            this.setArgs(new String[]{this.getOperation()});
            this.setValue(true);
            return theList;
        }
        throw new UnknownArgsException(aArgs, "The operation \"" + this.getOperation() + "\" was found in the command line arguments.");
    }

    public String getOperation() {
        return this._operation;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        aOptionEscCode = aOptionEscCode == null ? "" : aOptionEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        return String.valueOf(aOptionEscCode) + this.getOperation() + (this.getAlias() != null ? " " + CliUtility.toParameterSpec(this) : "") + aResetEscCode;
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(this.getOperation());
        theBuilder.append(":=");
        if (this.getValue() != null) {
            theBuilder.append(((Boolean)this.getValue()).toString());
        } else {
            theBuilder.append("null");
        }
        return theBuilder.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEnabled() {
        Boolean theValue = (Boolean)this.getValue();
        if (theValue != null) {
            return theValue;
        }
        return false;
    }

    @Override
    protected Boolean toValue(String aArg) throws ParseArgsException {
        throw new UnsupportedOperationException("*** NOT REQUIRED BY THIS IMPLEMENTATION ***");
    }
}

