/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class OptionalCondition
extends AbstractCondition {
    private static final String LEFT_TAG = "[ ";
    private static final String RIGHT_TAG = " ]";

    public OptionalCondition(Syntaxable ... aArgs) {
        super(aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        ArrayList theResult = new ArrayList();
        List<? extends Operand<?>> eOperands = null;
        for (Syntaxable eChild : this.getChildren()) {
            try {
                eOperands = eChild.parseArgs(aArgs, aOptions);
                if (eOperands != null) {
                    theResult.addAll(eOperands);
                }
                aArgs = CliUtility.toDiff(aArgs, eOperands);
            }
            catch (UnknownArgsException unknownArgsException) {
                // empty catch block
            }
        }
        return theResult;
    }

    @Override
    public String toUsage(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            StringBuilder theBuilder = new StringBuilder();
            for (Syntaxable eArgumentizer : this.getChildren()) {
                if (theBuilder.length() != 0) {
                    theBuilder.append(" ");
                }
                theBuilder.append(LEFT_TAG);
                theBuilder.append(eArgumentizer.toSyntax(aSyntaxNotation, aOptionEscCode, aResetEscCode));
                theBuilder.append(RIGHT_TAG);
            }
            return theBuilder.toString();
        }
        return "";
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(" ");
            }
            theBuilder.append(eArgumentizer.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }

    @Override
    public void reset() {
        this.getChildren().get(0).reset();
    }

    @Override
    public String toString() {
        return this.toState();
    }
}

