/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class OrCondition
extends AbstractCondition
implements Condition {
    private static final String GNU_POSIX_OR = " ? ";
    private static final String LOGICAL_OR = " | ";

    public OrCondition(Syntaxable ... aArgs) {
        super(aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        ArrayList theResult = null;
        for (Syntaxable eChild : this.getChildren()) {
            try {
                List<? extends Operand<?>> eOperands = eChild.parseArgs(aArgs, aOptions);
                if (eOperands != null) {
                    if (theResult == null) {
                        theResult = new ArrayList();
                    }
                    theResult.addAll(eOperands);
                }
                aArgs = CliUtility.toDiff(aArgs, eOperands);
            }
            catch (AmbiguousArgsException | UnknownArgsException argsMismatchException) {
                // empty catch block
            }
        }
        if (theResult != null) {
            return theResult;
        }
        throw new UnknownArgsException(aArgs, "Not any operand (option) matched the provided command line arguments; though at least one must match.");
    }

    @Override
    public String toUsage(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_OR);
                } else {
                    theBuilder.append(GNU_POSIX_OR);
                }
            }
            theBuilder.append(eArgumentizer.toSyntax(aSyntaxNotation, aOptionEscCode, aResetEscCode));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append("( ");
            } else {
                theBuilder.append(LOGICAL_OR);
            }
            theBuilder.append(eArgumentizer.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }
}

