/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.OptionalCondition;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.textual.VerboseTextBuilder;

public class XorCondition
extends AbstractCondition
implements Condition {
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final String GUN_POSIX_XOR = " | ";
    private static final String LOGICAL_XOR = " ^ ";

    public XorCondition(Syntaxable ... aArgs) {
        super(aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        ArrayList<Condition> theOptionals = new ArrayList<Condition>();
        List<Operand<?>> theResult = null;
        Syntaxable theResultSyntaxable = null;
        for (Syntaxable eChild : this.getChildren()) {
            if (eChild instanceof OptionalCondition) {
                theOptionals.add((OptionalCondition)eChild);
            }
            List<Operand<?>> eOperands = null;
            try {
                eOperands = theResult != null && eChild instanceof Operand && theResultSyntaxable instanceof Option ? eChild.parseArgs(CliUtility.toDiff(aArgs, theResult), aOptions) : eChild.parseArgs(aArgs, aOptions);
                if (eOperands != null && eOperands.isEmpty()) {
                    eOperands = null;
                }
            }
            catch (AmbiguousArgsException | UnknownArgsException argsMismatchException) {
                // empty catch block
            }
            if ((theResult = this.toRemoveDuplicates(theResult, eOperands)) != null && eOperands != null) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive operand (option) matched the provided command line arguments; though exactly one must match: " + new VerboseTextBuilder().withElements((Object[])CliUtility.toArgs(theResult, eOperands)).toString());
            }
            if (eOperands == null || eOperands.isEmpty() || theResult != null) continue;
            theResult = eOperands;
            theResultSyntaxable = eChild;
        }
        if (theResult != null) {
            return theResult;
        }
        if (theOptionals.size() == 1) {
            return Collections.EMPTY_LIST;
        }
        if (theOptionals.size() > 1 && aArgs != null && aArgs.length > 0) {
            throw new AmbiguousArgsException(aArgs, "None optional operand (option) matched the provided command line arguments; causing exclusive contextual ambiguity: " + new VerboseTextBuilder().withElements(XorCondition.toSpec(theOptionals)).toString());
        }
        throw new UnknownArgsException(aArgs, "Not one exclusive operand (option) matched the provided command line arguments; though exactly one must match.");
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder(this.toUsage(aSyntaxNotation, aOptionEscCode, aResetEscCode));
        if (theBuilder.length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.insert(0, LEFT_TAG);
            } else {
                theBuilder.insert(0, "{ ");
            }
            if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.append(RIGHT_TAG);
            } else {
                theBuilder.append(" }");
            }
        }
        return theBuilder.toString();
    }

    @Override
    public String toUsage(SyntaxNotation aSyntaxNotation, String aOptionEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_XOR);
                } else {
                    theBuilder.append(GUN_POSIX_XOR);
                }
            }
            theBuilder.append(eArgumentizer.toSyntax(aSyntaxNotation, aOptionEscCode, aResetEscCode));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eArgumentizer : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(LOGICAL_XOR);
            }
            theBuilder.append(eArgumentizer.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }

    private static List<String> toSpec(List<Condition> aConditions) {
        ArrayList<String> theParameters = new ArrayList<String>();
        for (Condition eCondition : aConditions) {
            for (Operand<?> eOperand : eCondition.toOperands()) {
                theParameters.add(CliUtility.toSpec(eOperand));
            }
        }
        return theParameters;
    }

    private List<Operand<?>> toRemoveDuplicates(List<Operand<?>> aElements, List<Operand<?>> aDuplicates) {
        if (aElements != null && aDuplicates != null) {
            for (Operand<?> eOperand : aDuplicates) {
                if (!aElements.contains(eOperand)) continue;
                aElements.remove(eOperand);
            }
            if (aElements.isEmpty()) {
                aElements = null;
            }
        }
        return aElements;
    }
}

