package org.refcodes.cli;

import static org.junit.jupiter.api.Assertions.*;
import static org.refcodes.cli.CliSugar.*;

import org.junit.jupiter.api.Test;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

/**
 * The Class OptionalConditionTest.
 */
public class OptionalConditionTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static boolean IS_LOG_TESTS = Boolean.getBoolean( "log.tests" );

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Test optional edge case.
	 */
	@Test
	public void testOptionalEdgeCase() {
		Option<Integer> theWidth = intOption( "-w", "--width", "width", "Sets the console width" );
		Option<Integer> thePortOption = intOption( "-p", "--port", "port", "Sets the port for the server" );
		Option<Integer> theMaxConns = intOption( "-c", "--connections", "connections", "Sets the number of max. connections" );
		Option<String> theUsername = stringOption( "-u", "--user", "username", "The username for HTTP Basic-Authentication" );
		Option<String> theSecret = stringOption( "-s", "--secret", "secret", "The password for HTTP Basic-Authentication" );
		Flag theSysInfo = flag( null, "--sysinfo", "sysInfo", "Shows some system information" );
		Option<Integer> theMgmPortOption = intOption( "-m", "--management-port", "management-port", "The management-port on which to listen for shutdown..." );
		Flag theHelp = helpFlag( "Shows this help" );

		// @formatter:off
		ArgsSyntax theRoot = any ( xor( 
			any( thePortOption, theMaxConns, and( theUsername, theSecret ), theWidth, theMgmPortOption ),
			any( xor( theHelp, theSysInfo ) ) )
		);
		// @formatter:on

		ArgsParser theArgsParser = new ArgsParserImpl( theRoot );
		theArgsParser.withSyntaxNotation( SyntaxNotation.REFCODES );
		theArgsParser.withName( "TinyRestful" ).withTitle( "TINYRESTFUL" ).withCopyrightNote( "Copyright (c) by FUNCODES.CLUB, Munich, Germany." ).withLicenseNote( "Licensed under GNU General Public License, v3.0 and Apache License, v2.0" );
		theArgsParser.withBannerFont( new FontImpl( FontFamily.DIALOG, FontStyle.BOLD ) ).withBannerFontPalette( AsciiColorPalette.MAX_LEVEL_GRAY.getPalette() );
		theArgsParser.withDescription( "Tiny evil RESTful server. TinyRestfulServer makes heavy use of the REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>." );

		String[] args = new String[] {
				"-p", "8080", "--sysinfo"
		};

		try {
			theArgsParser.evalArgs( args );
		}
		catch ( UnknownArgsException | AmbiguousArgsException | SuperfluousArgsException | ParseArgsException e ) {
			if ( IS_LOG_TESTS ) System.out.println( new VerboseTextBuilder().withElements( e.getArgs() ).toString() );
			if ( IS_LOG_TESTS ) System.out.println( e.getMessage() );
			assertEquals( 3, e.getArgs().length );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
