/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.ExampleUsage;
import org.refcodes.cli.Flag;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.OptionCondition;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Delimiter;
import org.refcodes.data.License;
import org.refcodes.data.Literal;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.runtime.Terminal;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.Relation;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserImpl
implements ArgsParser {
    private List<ExampleUsage> _exampleUsages = null;
    private Font _bannerFont = new FontImpl(FontFamily.DIALOG, FontStyle.PLAIN, 12);
    private char[] _bannerFontPalette = AsciiColorPalette.HALFTONE_GRAY.getPalette();
    private ArgsSyntax _rootArgsSyntax;
    private SyntaxNotation _syntaxNotation = SyntaxNotation.REFCODES;
    private int _consoleWidth = Terminal.toPreferredTerminalWidth();
    private int _maxConsoleWidth = -1;
    private String _lineBreak = Terminal.getLineBreak();
    private String _title = null;
    private String _name = "foobar";
    private String _description = "See the syntax declaration for usage, see the descriptions for the short- and the long-options. Option arguments are noted in angle brackets.";
    private String _usageLabel = "Usage";
    private String _licenseNote = License.LICENSE_NOTE.getText();
    private String _copyrightNote = License.COPYRIGHT_NOTE.getText();
    private boolean _isEscCodesEnabled = Terminal.isAnsiTerminalPreferred();
    private String _resetEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private String _paramEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _descriptionEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR});
    private String _bannerEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _bannerBorderEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private String _lineSeparatorEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT});
    private TextBoxGrid _textBoxGrid = TextBoxStyle.toRuntimeTextBoxStyle().getTextBoxGrid();
    private char _separatorLnChar = ((Character)this._textBoxGrid.getInnerLine()).charValue();
    private boolean _hasOverrideSeparatorLnChar = false;
    protected PrintStream _stdStream = RuntimeUtility.toSystemOut();
    protected PrintStream _errStream = RuntimeUtility.toSystemErr();

    public ArgsParserImpl() {
        this._rootArgsSyntax = null;
    }

    public ArgsParserImpl(ArgsSyntax argsSyntax) {
        this._rootArgsSyntax = argsSyntax;
    }

    public ArgsParserImpl(Option<?> option) {
        this._rootArgsSyntax = new OptionCondition(option);
    }

    @Override
    public String getLineSeparatorEscapeCode() {
        return this._lineSeparatorEscCode;
    }

    @Override
    public void setLineSeparatorEscapeCode(String string) {
        this._lineSeparatorEscCode = string;
    }

    @Override
    public String getBannerEscapeCode() {
        return this._bannerEscCode;
    }

    @Override
    public String getBannerBorderEscapeCode() {
        return this._bannerBorderEscCode;
    }

    @Override
    public void setBannerEscapeCode(String string) {
        this._bannerEscCode = string;
    }

    @Override
    public void setBannerBorderEscapeCode(String string) {
        this._bannerBorderEscCode = string;
    }

    @Override
    public String getParameterEscapeCode() {
        return this._paramEscCode;
    }

    @Override
    public void setParameterEscapeCode(String string) {
        this._paramEscCode = string;
    }

    @Override
    public void errorLn(String string) {
        if (string == null) {
            string = "null";
        }
        String[] stringArray = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{string})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._errStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._errStream.flush();
    }

    @Override
    public List<? extends Operand<?>> evalArgs(String[] stringArray) throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        if (this._rootArgsSyntax == null) {
            return ArgsParserImpl.fromArgs(stringArray, this.getDelimiter());
        }
        List<? extends Operand<?>> list = this._rootArgsSyntax.parseArgs(stringArray);
        Object[] objectArray = CliUtility.toDiff(stringArray, list);
        if (objectArray != null && objectArray.length > 0) {
            throw new SuperfluousArgsException((String[])objectArray, "Superfluous command arguments " + new VerboseTextBuilder().withElements(objectArray).toString() + " were provided but cannot be evaluated or are not supported as of the given combination of arguments.");
        }
        return list;
    }

    private String fromTextBlock(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (string != null && string.length() != 0 && stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString() + this.toLineBreak();
    }

    @Override
    public String getCopyrightNote() {
        return this._copyrightNote;
    }

    protected char getDelimiter() {
        return Delimiter.INDEX.getChar();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getLicenseNote() {
        return this._licenseNote;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public ArgsSyntax getRootArgsSyntax() {
        return this._rootArgsSyntax;
    }

    public String getResetEscapeCode() {
        return this._resetEscCode;
    }

    public void setResetEscapeCode(String string) {
        this._resetEscCode = string;
    }

    public String getTitle() {
        return this._title;
    }

    @Override
    public void printBanner() {
        int n = this._consoleWidth - 4;
        String[] stringArray = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(n).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        boolean bl = this.hasBorder(stringArray);
        if (bl) {
            n = this._consoleWidth - 2;
            stringArray = ((AsciiArtBuilder)new AsciiArtBuilder().withText(new String[]{this._title != null ? this._title : this._name})).withFont(this._bannerFont).withAsciiColors(this._bannerFontPalette).withColumnWidth(n).withAsciiArtMode(AsciiArtMode.NORMAL).withPixmapRatioMode(PixmapRatioMode.ONE_HALF).toStrings();
        }
        stringArray = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(stringArray)).withColumnWidth(n).withFillChar(' ').toStrings();
        if (!bl) {
            stringArray = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(stringArray)).withBorderWidth(1).withBorderChar(' ').toStrings();
        }
        stringArray = ((TextBorderBuilder)new TextBorderBuilder().withTextBoxGrid(this._textBoxGrid).withText(stringArray)).withBoxBorderMode(BoxBorderMode.ALL).toStrings();
        if (this._isEscCodesEnabled) {
            stringArray[0] = this._bannerBorderEscCode + stringArray[0] + this._resetEscCode;
            if (stringArray.length > 1) {
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    stringArray[i] = this._bannerBorderEscCode + stringArray[i].substring(0, 1) + this._resetEscCode + this._bannerEscCode + stringArray[i].substring(1, stringArray[i].length() - 1) + this._resetEscCode + this._bannerBorderEscCode + stringArray[i].substring(stringArray[i].length() - 1) + this._resetEscCode;
                }
            }
            stringArray[stringArray.length - 1] = this._bannerBorderEscCode + stringArray[stringArray.length - 1] + this._resetEscCode;
        }
        this._stdStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printCopyrightNote() {
        this._stdStream.println(this._copyrightNote);
        this._stdStream.flush();
    }

    @Override
    public void printDescription() {
        this._stdStream.println((this._isEscCodesEnabled ? this._descriptionEscCode : "") + this._description + (this._isEscCodesEnabled ? this._resetEscCode : ""));
        this._stdStream.flush();
    }

    @Override
    public void printLicenseNote() {
        this._stdStream.println(this._licenseNote);
        this._stdStream.flush();
    }

    @Override
    public void printLn() {
        this._stdStream.println();
        this._stdStream.flush();
    }

    @Override
    public void printLn(String string) {
        String[] stringArray = ((TextBlockBuilder)new TextBlockBuilder().withText(new String[]{string})).withColumnWidth(this._consoleWidth).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this._stdStream.print(this.fromTextBlock(stringArray, this.toLineBreak()));
        this._stdStream.flush();
    }

    @Override
    public void printOptions() {
        if (this._rootArgsSyntax != null) {
            List<Operand<?>> list = this._rootArgsSyntax.toOperands();
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            int n = 0;
            for (Operand<?> cloneable2 : list) {
                String string = CliUtility.toSpec(cloneable2);
                if (string.length() > n) {
                    n = string.length();
                }
                hashMap.put(string, new String[]{string, ":", " ", cloneable2.getDescription()});
            }
            TableBuilder tableBuilder = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            if (this._isEscCodesEnabled) {
                tableBuilder.setResetEscapeCode(this._resetEscCode);
                tableBuilder.setEscapeCodesEnabled(true);
            }
            tableBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(n, ColumnWidthType.ABSOLUTE);
            if (this._isEscCodesEnabled) {
                tableBuilder.withRowColumnEscapeCode(this._paramEscCode);
            }
            tableBuilder.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            if (this._isEscCodesEnabled) {
                tableBuilder.withRowColumnEscapeCode(this._descriptionEscCode);
            }
            tableBuilder.withLineBreak(this.toLineBreak());
            ArrayList arrayList = new ArrayList(hashMap.keySet());
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string != null) {
                        while (string.startsWith("-")) {
                            string = string.substring(1);
                        }
                    }
                    if (string2 != null) {
                        while (string2.startsWith("-")) {
                            string2 = string2.substring(1);
                        }
                    }
                    return string.compareToIgnoreCase(string2);
                }
            });
            for (String string : arrayList) {
                tableBuilder.printRowContinue((String[])hashMap.get(string));
            }
        }
    }

    @Override
    public void printExampleUsages() {
        if (this._exampleUsages != null && this._exampleUsages.size() != 0) {
            int n = 0;
            for (ExampleUsage object : this._exampleUsages) {
                String string = object._description;
                if (string.length() <= n) continue;
                n = string.length();
            }
            if (n > this._consoleWidth / 2 && (n = this._consoleWidth / 2) < ConsoleDimension.MIN_WIDTH.getValue() / 2) {
                n = ConsoleDimension.MIN_WIDTH.getValue() / 2;
            }
            TableBuilder tableBuilder = new TableBuilder().withTableStyle(TableStyle.BLANK_HEADER_BLANK_BODY).withRowWidth(this._consoleWidth).withPrintStream(this._stdStream).withEscapeCodesEnabled(this._isEscCodesEnabled).withLeftBorder(false).withRightBorder(false).withDividerLine(false);
            if (this._isEscCodesEnabled) {
                tableBuilder.setEscapeCodesEnabled(true);
                tableBuilder.setResetEscapeCode(this._resetEscCode);
            }
            tableBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).withColumnWidth(n, ColumnWidthType.ABSOLUTE);
            if (this._isEscCodesEnabled) {
                tableBuilder.withRowColumnEscapeCode(this._descriptionEscCode);
            }
            tableBuilder.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnWidth(1, ColumnWidthType.ABSOLUTE);
            tableBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT).withColumnSplitTextMode(SplitTextMode.AT_SPACE);
            if (this._isEscCodesEnabled) {
                tableBuilder.withRowColumnEscapeCode(this._paramEscCode);
            }
            tableBuilder.withLineBreak(this.toLineBreak());
            for (ExampleUsage exampleUsage : this._exampleUsages) {
                Object object = "";
                for (Operand<?> operand : exampleUsage.getOperands()) {
                    if (((String)object).length() != 0) {
                        object = (String)object + " ";
                    }
                    if (operand instanceof Flag) {
                        Flag flag = (Flag)operand;
                        object = (String)object + (flag.getShortOption() != null ? flag.getShortOption() : flag.getLongOption());
                        continue;
                    }
                    if (operand instanceof Option) {
                        Option option = (Option)operand;
                        object = (String)object + (option.getShortOption() != null ? option.getShortOption() : option.getLongOption());
                        object = (String)object + " <" + (option.getAlias() != null ? option.getAlias() : option.getType().getSimpleName()) + ">";
                        continue;
                    }
                    object = (String)object + " <" + (operand.getAlias() != null ? operand.getAlias() : operand.getType().getSimpleName()) + ">";
                }
                tableBuilder.printRowContinue(new String[]{exampleUsage.getDescription(), ":", " ", object});
            }
        }
    }

    @Override
    public void printSeparatorLn() {
        String string = new TextLineBuilder().withColumnWidth(this._consoleWidth).withLineChar(this._separatorLnChar).toString() + this.toLineBreak();
        if (this._isEscCodesEnabled) {
            string = this._lineSeparatorEscCode + string + this._resetEscCode;
        }
        this._stdStream.print(string);
        this._stdStream.flush();
    }

    @Override
    public void printUsage() {
        String string = this._rootArgsSyntax != null ? (this._isEscCodesEnabled ? this._rootArgsSyntax.toUsage(this._syntaxNotation, this._paramEscCode, this._resetEscCode) : this._rootArgsSyntax.toUsage(this._syntaxNotation)) : "<?>";
        String string2 = this._usageLabel + ": " + this._name + " " + string;
        this._stdStream.println(string2);
        this._stdStream.flush();
    }

    public void reset() {
        if (this._rootArgsSyntax != null) {
            this._rootArgsSyntax.reset();
        }
    }

    @Override
    public void setBannerFont(Font font) {
        this._bannerFont = font;
    }

    @Override
    public void setBannerFontPalette(char[] cArray) {
        this._bannerFontPalette = cArray;
    }

    @Override
    public void setConsoleWidth(int n) {
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < n ? this._maxConsoleWidth : n) : n;
    }

    @Override
    public void setCopyrightNote(String string) {
        this._copyrightNote = string;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    @Override
    public void setErrorOut(PrintStream printStream) {
        this._errStream = printStream;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscCodesEnabled;
    }

    public void setEscapeCodesEnabled(boolean bl) {
        this._isEscCodesEnabled = bl;
    }

    @Override
    public String getDescriptionEscapeCode() {
        return this._descriptionEscCode;
    }

    @Override
    public void setDescriptionEscapeCode(String string) {
        this._descriptionEscCode = string;
    }

    @Override
    public void setLicenseNote(String string) {
        this._licenseNote = string;
    }

    @Override
    public void setLineBreak(String string) {
        if (string == null) {
            string = Terminal.getLineBreak();
        }
        this._lineBreak = string;
    }

    @Override
    public void setMaxConsoleWidth(int n) {
        this._maxConsoleWidth = n;
        this._consoleWidth = this._maxConsoleWidth != -1 ? (this._maxConsoleWidth < this._consoleWidth ? this._maxConsoleWidth : this._consoleWidth) : this._consoleWidth;
    }

    public void setName(String string) {
        this._name = string;
    }

    @Override
    public void setSeparatorLnChar(char c) {
        this._separatorLnChar = c;
        this._hasOverrideSeparatorLnChar = true;
    }

    @Override
    public char getSeparatorLnChar() {
        return this._separatorLnChar;
    }

    @Override
    public void setStandardOut(PrintStream printStream) {
        this._stdStream = printStream;
    }

    @Override
    public void setSyntaxNotation(SyntaxNotation syntaxNotation) {
        this._syntaxNotation = syntaxNotation;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    @Override
    public void setUsageLabel(String string) {
        this._usageLabel = string;
    }

    public TextBoxGrid getTextBoxGrid() {
        return this._textBoxGrid;
    }

    public void setTextBoxGrid(TextBoxGrid textBoxGrid) {
        this._textBoxGrid = textBoxGrid;
        if (!this._hasOverrideSeparatorLnChar) {
            this._separatorLnChar = ((Character)textBoxGrid.getInnerLine()).charValue();
        }
    }

    @Override
    public List<ExampleUsage> getExampleUsages() {
        return this._exampleUsages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExampleUsage(ExampleUsage exampleUsage) {
        if (this._exampleUsages == null) {
            ArgsParserImpl argsParserImpl = this;
            synchronized (argsParserImpl) {
                if (this._exampleUsages == null) {
                    this._exampleUsages = new ArrayList<ExampleUsage>();
                }
            }
        }
        this._exampleUsages.add(exampleUsage);
    }

    protected static List<? extends Operand<?>> fromArgs(String[] stringArray, char c) {
        ArrayList<AbstractOperand> arrayList = new ArrayList<AbstractOperand>();
        Map map = RuntimeUtility.toProperties((String[])stringArray, (String[])CommandArgPrefix.toPrefixes(), (char)c);
        for (String string : map.keySet()) {
            if (Literal.TRUE.getValue().equalsIgnoreCase((String)map.get(string))) {
                arrayList.add(new Flag(string, true));
                continue;
            }
            arrayList.add(new StringOperand((Relation<String, String>)new PropertyImpl(string, (String)map.get(string))));
        }
        return arrayList;
    }

    private String toLineBreak() {
        if (Terminal.isLineBreakRequired((int)this._consoleWidth)) {
            return this._lineBreak;
        }
        return "";
    }

    private boolean hasBorder(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            int n;
            char c = stringArray[0].length() != 0 ? (char)stringArray[0].charAt(0) : (char)' ';
            for (n = 0; n < stringArray[0].length(); ++n) {
                if (c != stringArray[0].charAt(n)) {
                    return false;
                }
                c = stringArray[0].charAt(n);
            }
            for (n = 0; n < stringArray[stringArray.length - 1].length(); ++n) {
                if (c != stringArray[stringArray.length - 1].charAt(n)) {
                    return false;
                }
                c = stringArray[stringArray.length - 1].charAt(n);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (c != stringArray[n].charAt(0)) {
                    return false;
                }
                c = stringArray[n].charAt(0);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (c != stringArray[n].charAt(stringArray[n].length() - 1)) {
                    return false;
                }
                c = stringArray[n].charAt(stringArray[n].length() - 1);
            }
        }
        return true;
    }
}

