/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.textual.VerboseTextBuilder;

public class AllCondition
extends AbstractCondition
implements Condition {
    private static final String ALL_ARGS = "\u2200";
    private static final String LEFT_TAG = "( ";
    private static final String RIGHT_TAG = " )";

    public AllCondition(Syntaxable syntaxable) {
        super(syntaxable);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] stringArray, String[] stringArray2) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        List<? extends Operand<?>> list = this.getFirst().parseArgs(stringArray, stringArray2);
        String[] stringArray3 = CliUtility.toDiff(stringArray, list);
        if (stringArray3 != null && stringArray3.length != 0) {
            throw new SuperfluousArgsException(stringArray3, "There were command line arguments (" + VerboseTextBuilder.asString((String[])stringArray3) + ") ");
        }
        return list;
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Syntaxable syntaxable : this.getChildren()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                if (syntaxNotation == SyntaxNotation.REFCODES) {
                    stringBuilder.append(ALL_ARGS);
                    stringBuilder.append(LEFT_TAG);
                }
                stringBuilder.append(syntaxable.toSyntax(syntaxNotation, string, string2, string3));
                if (syntaxNotation != SyntaxNotation.REFCODES) continue;
                stringBuilder.append(RIGHT_TAG);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public String toSynopsis(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            if (this.getChildren().size() == 1) {
                return this.getChildren().get(0).toSynopsis(syntaxNotation, string, string2, string3);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Syntaxable syntaxable : this.getChildren()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(syntaxable.toSyntax(syntaxNotation, string, string2, string3));
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public String toState() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(ALL_ARGS);
                stringBuilder.append(LEFT_TAG);
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(syntaxable.toState());
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(RIGHT_TAG);
        }
        return stringBuilder.toString();
    }

    @Override
    public void reset() {
        this.getChildren().get(0).reset();
    }

    @Override
    public String toString() {
        return this.toState();
    }
}

