// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import org.refcodes.struct.Relation;

/**
 * The {@link IntOption} represents an {@link Option} holding <code>int</code>
 * values.
 */
public class IntOption extends AbstractOption<Integer> {

	// /////////////////////////////////////////////////////////////////////////
	// STATIC:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new integer option impl.
	 *
	 * @param aLongOption the long option
	 * @param aAlias the option arg name
	 * @param aDescription the description
	 */
	public IntOption( String aLongOption, String aAlias, String aDescription ) {
		this( null, aLongOption, aAlias, aDescription );
	}

	/**
	 * Instantiates a new integer option impl.
	 *
	 * @param aShortOption the short option
	 * @param aLongOption the long option
	 * @param aAlias the option arg name
	 * @param aDescription the description
	 */
	public IntOption( String aShortOption, String aLongOption, String aAlias, String aDescription ) {
		super( aShortOption, aLongOption, Integer.class, aAlias, aDescription );
	}

	/**
	 * Instantiates a new integer option impl.
	 *
	 * @param aProperty The key (= alias) and the value for the operand.
	 */
	public IntOption( Relation<String, Integer> aProperty ) {
		super( aProperty, Integer.class );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Integer toType( String aArg ) throws ParseArgsException {
		try {
			return Integer.valueOf( aArg );
		}
		catch ( NumberFormatException e ) {
			throw new ParseArgsException( new String[] {
					aArg
			}, "Unable to parse the argument <" + aArg + "> of option \"" + getAlias() + "\" to an <int> value.", e );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
