// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import org.refcodes.struct.Relation;

/**
 * An {@link Operand} (neither a short option nor a long option prepended nor
 * being a switch) being s {@link String}. An {@link Operand} stands by itself
 * and represents itself.
 */
public class StringOperand extends AbstractOperand<String> {

	// /////////////////////////////////////////////////////////////////////////
	// STATIC:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new string operand impl.
	 *
	 * @param aAlias The identifier to be used when printing the syntax via the
	 *        {@link #toSyntax(SyntaxNotation, String, String, String)} method.
	 * @param aDescription A description without any line breaks.
	 */
	public StringOperand( String aAlias, String aDescription ) {
		super( String.class, aAlias, aDescription );
	}

	/**
	 * Instantiates a new string operand impl.
	 *
	 * @param aProperty The key (= alias) and the value for the operand.
	 */
	public StringOperand( Relation<String, String> aProperty ) {
		super( aProperty, String.class );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * To value.
	 *
	 * @param aArg the arg
	 * 
	 * @return the string
	 */
	@Override
	protected String toType( String aArg ) {
		return aArg;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
