/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class AndCondition
extends AbstractCondition
implements Condition {
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final char GUN_POSIX_AND = ' ';
    private static final String LOGICAL_AND = " & ";

    public AndCondition(Syntaxable ... syntaxableArray) {
        super(syntaxableArray);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] stringArray, String[] stringArray2) throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        ArrayList arrayList = new ArrayList();
        for (Syntaxable syntaxable : this.getChildren()) {
            List<Operand<?>> list;
            try {
                list = syntaxable.parseArgs(stringArray, stringArray2);
            }
            catch (UnknownArgsException unknownArgsException) {
                throw new UnknownArgsException(unknownArgsException.getArgs(), "At least one mandatory operand (option) did not match the provided command line arguments; though all must match.", (Throwable)((Object)unknownArgsException));
            }
            catch (AmbiguousArgsException ambiguousArgsException) {
                throw new AmbiguousArgsException(ambiguousArgsException.getArgs(), "At least one mandatory operand (option) did not match the provided command line arguments; though all must match.", (Throwable)((Object)ambiguousArgsException));
            }
            if (list != null && list.size() != 0) {
                arrayList.addAll(list);
            }
            stringArray = CliUtility.toDiff(stringArray, list);
        }
        return arrayList;
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() != 0) {
                if (syntaxNotation == SyntaxNotation.REFCODES) {
                    stringBuilder.append(LOGICAL_AND);
                } else {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(syntaxable.toSyntax(syntaxNotation, string, string2, string3));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(LEFT_TAG);
            } else {
                stringBuilder.append(LOGICAL_AND);
            }
            stringBuilder.append(syntaxable.toState());
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(RIGHT_TAG);
        }
        return stringBuilder.toString();
    }
}

