/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.textual.VerboseTextBuilder;

public class AllCondition
extends AbstractCondition
implements Condition {
    private static final String ALL_ARGS = "\u2200";
    private static final String LEFT_TAG = "( ";
    private static final String RIGHT_TAG = " )";

    public AllCondition(Syntaxable aArg) {
        super(aArg);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        List<? extends Operand<?>> theResult = this.getFirst().parseArgs(aArgs, aOptions);
        String[] theRemainderArgs = CliUtility.toDiff(aArgs, theResult);
        if (theRemainderArgs != null && theRemainderArgs.length != 0) {
            throw new SuperfluousArgsException(theRemainderArgs, "There were command line arguments (" + VerboseTextBuilder.asString((String[])theRemainderArgs) + ") ");
        }
        return theResult;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            StringBuilder theBuilder = new StringBuilder();
            for (Syntaxable eChild : this.getChildren()) {
                if (theBuilder.length() != 0) {
                    theBuilder.append(" ");
                }
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(ALL_ARGS);
                    theBuilder.append(LEFT_TAG);
                }
                theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
                if (aSyntaxNotation != SyntaxNotation.REFCODES) continue;
                theBuilder.append(RIGHT_TAG);
            }
            return theBuilder.toString();
        }
        return "";
    }

    @Override
    public String toSynopsis(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            if (this.getChildren().size() == 1) {
                return this.getChildren().get(0).toSynopsis(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode);
            }
            StringBuilder theBuilder = new StringBuilder();
            for (Syntaxable eChild : this.getChildren()) {
                if (theBuilder.length() != 0) {
                    theBuilder.append(" ");
                }
                theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
            }
            return theBuilder.toString();
        }
        return "";
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(ALL_ARGS);
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(" ");
            }
            theBuilder.append(eChild.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }

    @Override
    public void reset() {
        this.getChildren().get(0).reset();
    }

    @Override
    public String toString() {
        return this.toState();
    }
}

