/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class AnyCondition
extends AbstractCondition
implements Condition {
    private static final String LEFT_TAG = "[ ";
    private static final String RIGHT_TAG = " ]";

    public AnyCondition(Syntaxable ... aArgs) {
        super(aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        ArrayList theResult = new ArrayList();
        List<? extends Operand<?>> eOperands = null;
        for (Syntaxable eChild : this.getChildren()) {
            try {
                eOperands = eChild.parseArgs(aArgs, aOptions);
                if (eOperands != null) {
                    theResult.addAll(eOperands);
                }
                aArgs = CliUtility.toDiff(aArgs, eOperands);
            }
            catch (UnknownArgsException unknownArgsException) {
                // empty catch block
            }
        }
        return theResult;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            StringBuilder theBuilder = new StringBuilder();
            for (Syntaxable eChild : this.getChildren()) {
                if (theBuilder.length() != 0) {
                    theBuilder.append(" ");
                }
                theBuilder.append(LEFT_TAG);
                theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
                theBuilder.append(RIGHT_TAG);
            }
            return theBuilder.toString();
        }
        return "";
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(" ");
            }
            theBuilder.append(eChild.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }

    @Override
    public void reset() {
        this.getChildren().get(0).reset();
    }

    @Override
    public String toString() {
        return this.toState();
    }
}

