/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.EnabledAccessor;
import org.refcodes.struct.Relation;

public class NoneOperand
extends AbstractOperand<Boolean>
implements Operand<Boolean>,
EnabledAccessor {
    private static final String EMPTY_SET = "\u2205";

    public NoneOperand(String aDescription) {
        super(Boolean.class, EMPTY_SET, aDescription);
    }

    public NoneOperand(String aAlias, String aDescription) {
        super(Boolean.class, aAlias, aDescription);
    }

    public NoneOperand(Relation<String, Boolean> aProperty) {
        super(aProperty, Boolean.class);
    }

    @Override
    public List<Operand<Boolean>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        boolean isEmpty = aArgs == null || aArgs.length == 0;
        this.setValue(isEmpty);
        if (!isEmpty) {
            throw new UnknownArgsException(aArgs, "No arguments are expected but <" + aArgs.length + "> arguments have been provided!");
        }
        ArrayList<Operand<Boolean>> theResult = new ArrayList<Operand<Boolean>>();
        theResult.add(this);
        return theResult;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        aParamEscCode = aParamEscCode == null ? "" : aParamEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        return String.valueOf(aParamEscCode) + EMPTY_SET + aResetEscCode;
    }

    @Override
    public String toState() {
        return EMPTY_SET;
    }

    public boolean isEnabled() {
        Boolean theValue = (Boolean)this.getValue();
        if (theValue != null) {
            return theValue;
        }
        return false;
    }

    @Override
    protected Boolean toType(String aArg) {
        if (aArg != null && aArg.length() != 0) {
            return false;
        }
        return true;
    }
}

