/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class OptionalConditionTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testOptionalEdgeCase() {
        IntOption intOption = CliSugar.intOption((String)"-w", (String)"--width", (String)"width", (String)"Sets the console width");
        IntOption intOption2 = CliSugar.intOption((String)"-p", (String)"--port", (String)"port", (String)"Sets the port for the server");
        IntOption intOption3 = CliSugar.intOption((String)"-c", (String)"--connections", (String)"connections", (String)"Sets the number of max. connections");
        StringOption stringOption = CliSugar.stringOption((String)"-u", (String)"--user", (String)"username", (String)"The username for HTTP Basic-Authentication");
        StringOption stringOption2 = CliSugar.stringOption((String)"-s", (String)"--secret", (String)"secret", (String)"The password for HTTP Basic-Authentication");
        Flag flag = CliSugar.flag(null, (String)"--sysinfo", (String)"sysInfo", (String)"Shows some system information");
        IntOption intOption4 = CliSugar.intOption((String)"-m", (String)"--management-port", (String)"management-port", (String)"The management-port on which to listen for shutdown...");
        HelpFlag helpFlag = CliSugar.helpFlag((String)"Shows this help");
        ArgsSyntax argsSyntax = CliSugar.any((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{intOption2, intOption3, CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption, stringOption2}), intOption, intOption4}), CliSugar.any((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{helpFlag, flag})})})});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.withName("TinyRestful").withTitle("TINYRESTFUL").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        argsParserImpl.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        argsParserImpl.withDescription("Tiny evil RESTful server. TinyRestfulServer makes heavy use of the REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        String[] stringArray = new String[]{"-p", "8080", "--sysinfo"};
        try {
            argsParserImpl.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (IS_LOG_TESTS) {
                System.out.println(new VerboseTextBuilder().withElements((Object[])argsSyntaxException.getArgs()).toString());
            }
            if (IS_LOG_TESTS) {
                System.out.println(argsSyntaxException.getMessage());
            }
            Assertions.assertEquals((int)3, (int)argsSyntaxException.getArgs().length);
        }
    }
}

