/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class AnyCondition
extends AbstractCondition
implements Condition {
    private static final String LEFT_TAG = "[ ";
    private static final String RIGHT_TAG = " ]";

    public AnyCondition(Syntaxable ... syntaxableArray) {
        super(syntaxableArray);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] stringArray, String[] stringArray2) throws ArgsSyntaxException {
        ArrayList arrayList = new ArrayList();
        List<? extends Operand<?>> list = null;
        for (Syntaxable syntaxable : this.getChildren()) {
            try {
                list = syntaxable.parseArgs(stringArray, stringArray2);
                if (list != null) {
                    arrayList.addAll(list);
                }
                stringArray = CliUtility.toDiff(stringArray, list);
            }
            catch (UnknownArgsException unknownArgsException) {}
        }
        return arrayList;
    }

    @Override
    public String toSyntax(SyntaxNotation syntaxNotation, String string, String string2, String string3) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Syntaxable syntaxable : this.getChildren()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(LEFT_TAG);
                stringBuilder.append(syntaxable.toSyntax(syntaxNotation, string, string2, string3));
                stringBuilder.append(RIGHT_TAG);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public String toState() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Syntaxable syntaxable : this.getChildren()) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(LEFT_TAG);
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(syntaxable.toState());
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append(RIGHT_TAG);
        }
        return stringBuilder.toString();
    }

    @Override
    public void reset() {
        this.getChildren().get(0).reset();
    }

    @Override
    public String toString() {
        return this.toState();
    }
}

