/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AllCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.OrCondition;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static String[][] ARGS = new String[][]{{"--name", "FILE", "--boolean", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static String[][] PROPERTIES = new String[][]{{"name=FILE", "boolean=true", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testEdgeCase1() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption, stringOption2, CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{helpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{sysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{verboseFlag})})})});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.evalArgs(new String[]{"-i", "in", "-o", "out"});
    }

    @Test
    public void testEdgeCase2() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption, stringOption2, CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{helpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{sysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{verboseFlag})})})});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        try {
            argsParserImpl.evalArgs(new String[0]);
            Assertions.fail((String)("Expected an <" + UnknownArgsException.class.getName() + ">!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeCase3() throws ArgsSyntaxException {
        EnumOption enumOption = CliSugar.enumOption((String)"--encoding", BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])BaseMetricsConfig.values())));
        Flag flag = CliSugar.flag((String)"--base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag flag2 = CliSugar.flag((String)"-d", (String)"--decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the message (stream, file, text or bytes).");
        Flag flag3 = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
        Flag flag4 = CliSugar.flag((String)"--verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption intOption = CliSugar.intOption((String)"--line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        StringOption stringOption = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        ArgsSyntax argsSyntax = CliSugar.and((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{flag3, CliSugar.any((Syntaxable[])new Syntaxable[]{flag4, CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{flag, CliSugar.any((Syntaxable[])new Syntaxable[]{intOption})}), CliSugar.and((Syntaxable[])new Syntaxable[]{enumOption, CliSugar.any((Syntaxable[])new Syntaxable[]{intOption})})})})}), flag2}), CliSugar.any((Syntaxable[])new Syntaxable[]{stringOption, stringOption2})});
        String[] stringArray = new String[]{"-e", "-i", "input.dat", "-o", "output.txt"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.evalArgs(stringArray);
    }

    @Test
    public void testEdgeCase4() throws ArgsSyntaxException {
        EnumOption enumOption = CliSugar.enumOption((String)"--chaos-mode", ChaosMode.class, (String)"CHAOS_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption enumOption2 = CliSugar.enumOption((String)"--context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag flag = CliSugar.flag((String)"--prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        StringOption stringOption = CliSugar.stringOption((String)"-c", (String)"--cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption stringOption2 = CliSugar.stringOption((String)"-p", (String)"--password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{flag, stringOption2, enumOption2}), enumOption}), CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption, CliSugar.any((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{flag, stringOption2, enumOption2})})})})});
        String[] stringArray = new String[]{"-p", "Hallo Welt!", "--cert-file", "C"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.evalArgs(stringArray);
    }

    @Test
    public void testEdgeCase5() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((String)"-e", (String)"--echo", (String)"TEXT_PROPERTY", (String)"Echoes the provided message to the standard out stream.");
        ConfigOption configOption = CliSugar.configOption();
        InitFlag initFlag = CliSugar.initFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag();
        HelpFlag helpFlag = CliSugar.helpFlag();
        DebugFlag debugFlag = CliSugar.debugFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption, CliSugar.any((Syntaxable[])new Syntaxable[]{configOption, verboseFlag, debugFlag})}), CliSugar.and((Syntaxable[])new Syntaxable[]{initFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{configOption, verboseFlag})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{helpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{sysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{verboseFlag})})})});
        String[] stringArray = new String[]{};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getSimpleName() + "> exception!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgCase6() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption stringOption2 = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag debugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        SysInfoFlag sysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag helpFlag = CliSugar.helpFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{stringOption, CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption2, CliSugar.any((Syntaxable[])new Syntaxable[]{verboseFlag})}), debugFlag}), CliSugar.and((Syntaxable[])new Syntaxable[]{stringOption, CliSugar.and((Syntaxable[])new Syntaxable[]{debugFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{verboseFlag})})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{helpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{sysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{verboseFlag})})})});
        String[] stringArray = new String[]{"-i", "someInputFile"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.evalArgs(stringArray);
    }

    @Test
    public void testAnyCase1() {
        DebugFlag debugFlag = CliSugar.debugFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        QuietFlag quietFlag = CliSugar.quietFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        try {
            argsParserImpl.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (IS_LOG_TESTS) {
                System.out.println(argsSyntaxException.getMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)debugFlag.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase2() {
        DebugFlag debugFlag = CliSugar.debugFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        QuietFlag quietFlag = CliSugar.quietFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{"-q"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        try {
            argsParserImpl.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (IS_LOG_TESTS) {
                System.out.println(argsSyntaxException.getMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)debugFlag.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase3() {
        DebugFlag debugFlag = CliSugar.debugFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        QuietFlag quietFlag = CliSugar.quietFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{"-d", "-v"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        try {
            argsParserImpl.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (IS_LOG_TESTS) {
                System.out.println(argsSyntaxException.getMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)debugFlag.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase4() {
        DebugFlag debugFlag = CliSugar.debugFlag();
        VerboseFlag verboseFlag = CliSugar.verboseFlag();
        QuietFlag quietFlag = CliSugar.quietFlag();
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
        String[] stringArray = new String[]{"-d"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        try {
            argsParserImpl.evalArgs(stringArray);
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            if (IS_LOG_TESTS) {
                System.out.println(argsSyntaxException.getMessage());
                argsSyntaxException.printStackTrace();
            }
            Assertions.fail((String)argsSyntaxException.getMessage());
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)debugFlag.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)quietFlag.isEnabled());
    }

    @Test
    public void testAnyCase5() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-q", "-d"};
            ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
            try {
                argsParserImpl.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException unknownArgsException) {
                if (!IS_LOG_TESTS) break block3;
                System.out.println(unknownArgsException.getMessage());
            }
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase6() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-v", "-q"};
            ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
            try {
                argsParserImpl.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException unknownArgsException) {
                if (!IS_LOG_TESTS) break block3;
                System.out.println(unknownArgsException.getMessage());
            }
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase7() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-d", "-v", "-q"};
            ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
            try {
                argsParserImpl.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException unknownArgsException) {
                if (!IS_LOG_TESTS) break block3;
                System.out.println(unknownArgsException.getMessage());
            }
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyXor1() throws ArgsSyntaxException {
        QuietFlag quietFlag;
        VerboseFlag verboseFlag;
        DebugFlag debugFlag;
        block3: {
            debugFlag = CliSugar.debugFlag();
            verboseFlag = CliSugar.verboseFlag();
            quietFlag = CliSugar.quietFlag();
            ArgsSyntax argsSyntax = CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{debugFlag, verboseFlag}), quietFlag});
            String[] stringArray = new String[]{"-q", "-d"};
            ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
            try {
                argsParserImpl.evalArgs(stringArray);
                Assertions.fail((String)("Expected a <" + AmbiguousArgsException.class.getName() + "> exception!"));
            }
            catch (AmbiguousArgsException ambiguousArgsException) {
                if (!IS_LOG_TESTS) break block3;
                System.out.println(ambiguousArgsException.getMessage());
            }
        }
        if (IS_LOG_TESTS) {
            System.out.println(debugFlag.getAlias() + " := " + debugFlag.isEnabled());
            System.out.println(verboseFlag.getAlias() + " := " + verboseFlag.isEnabled());
            System.out.println(quietFlag.getAlias() + " := " + quietFlag.isEnabled());
        }
    }

    @Test
    public void testParser1() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption});
        String[] stringArray = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser2() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AnyCondition anyCondition = new AnyCondition(new Syntaxable[]{xorCondition});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{anyCondition, stringOption});
        String[] stringArray = new String[]{"-f", "someFile", "-d"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        if (IS_LOG_TESTS) {
            System.out.println(andCondition.toSynopsis());
        }
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)((Boolean)flag.getValue()));
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser3() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser4() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser5() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOperand});
        String[] stringArray = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            Assertions.assertEquals((int)1, (int)superfluousArgsException.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)superfluousArgsException.getArgs()[0]);
        }
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser6() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser7() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag, flag2});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testParser8() {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{flag2, flag});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{stringOperand, xorCondition, stringOption, stringOption2});
        List list = andCondition.toOperands();
        Collections.sort(list);
        this.doLogOperands(list);
    }

    @Test
    public void testParser9() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption stringOption2 = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag flag = new Flag("-a", null, null, "Add the specified file");
        Flag flag2 = new Flag("-c", null, null, "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Syntaxable[]{flag, flag2});
        Flag flag3 = new Flag("-d", null, null, "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        List list = argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)((Boolean)flag.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)stringOperand.getValue());
        this.doLogArgs((ArgsParser)argsParserImpl, stringArray);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws ArgsSyntaxException {
        StringOption stringOption = new StringOption("-f", "--from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption stringOption2 = new StringOption("-t", "--to", "to", "The destination file to be processed");
        Flag flag = new Flag("-a", "--add", "add", "Add the specified file");
        Flag flag2 = new Flag("-c", "--create", "create", "Creates the specified file");
        OrCondition orCondition = new OrCondition(new Syntaxable[]{flag, flag2});
        Flag flag3 = new Flag("-d", "--delete", "delete", "Delete the specified file");
        StringOperand stringOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{orCondition, flag3});
        AndCondition andCondition = new AndCondition(new Syntaxable[]{xorCondition, stringOption, stringOption2, stringOperand});
        String[] stringArray = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)andCondition);
        if (IS_LOG_TESTS) {
            System.out.println(andCondition.toSynopsis());
        }
        argsParserImpl.evalArgs(stringArray);
        String string = (String)andCondition.toValue("from");
        String string2 = (String)andCondition.toValue("to");
        boolean bl = (Boolean)andCondition.toValue("add");
        boolean bl2 = (Boolean)andCondition.toValue("create");
        boolean bl3 = (Boolean)andCondition.toValue("delete");
        if (IS_LOG_TESTS) {
            System.out.println("From := " + string);
        }
        if (IS_LOG_TESTS) {
            System.out.println("To := " + string2);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Add := " + bl);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Create := " + bl2);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Delete := " + bl3);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)string);
        Assertions.assertEquals((Object)"toFile", (Object)string2);
        Assertions.assertTrue((boolean)bl);
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertFalse((boolean)bl3);
    }

    @Test
    public void testArgsProperties() throws ArgsSyntaxException {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Test
    public void testProductionError() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-l", "1", "-s", "100", "-f", "1"};
        DoubleOption doubleOption = CliSugar.doubleOption((String)"-f", (String)"--frequency", (String)"FREQUENCY_HZ", (String)"The frequency (Hz) to use when generating the values.");
        IntOption intOption = CliSugar.intOption((String)"-s", (String)"--sampling-rate", (String)"SAMPLING_RATE", (String)"The sample rate (per second) for the generated values (defaults to DEFAULT_SAMPLING_RATE_PER_SEC samples/second).");
        DoubleOption doubleOption2 = CliSugar.doubleOption((String)"-l", (String)"--length", (String)"LENGTH_SEC", (String)"The length (in seconds) for the generated values (defaults to DFAULT_LENGTH_SEC seconds).");
        ArgsSyntax argsSyntax = CliSugar.and((Syntaxable[])new Syntaxable[]{doubleOption, CliSugar.any((Syntaxable[])new Syntaxable[]{doubleOption2, intOption})});
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.withName("Waves").withTitle("~waves~").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        argsParserImpl.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        argsParserImpl.withDescription("Generate (sound) wave tables for given frequencies and amplitudes. Export them as CSV for further processing. Makes heavy use of the  REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        argsParserImpl.evalArgs(stringArray);
    }

    @Test
    public void testXorEdgeCase1() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((String)"-t", (String)"--text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        Flag flag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given message.");
        ArgsSyntax argsSyntax = CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{flag, stringOption}), new AllCondition((Syntaxable)flag)});
        String[] stringArray = new String[]{"-t", "text", "-e"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertEquals((Object)"text", (Object)stringOption.getValue());
    }

    @Test
    public void testXorEdgeCase2() throws ArgsSyntaxException {
        StringOption stringOption = CliSugar.stringOption((String)"-t", (String)"--text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        Flag flag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given message.");
        ArgsSyntax argsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{flag, stringOption}), flag});
        String[] stringArray = new String[]{"-t", "text", "-e"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl(argsSyntax);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertEquals((Object)"text", (Object)stringOption.getValue());
    }

    @Test
    public void testArrayOption1() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption2() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption3() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3", "-t", "text4"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <SuperfluousArgsException>!");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption4() throws ArgsSyntaxException {
        String[] stringArray = new String[]{};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            argsParserImpl.evalArgs(stringArray);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption5() throws ArgsSyntaxException {
        String[] stringArray = new String[]{};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)new AnyCondition(new Syntaxable[]{arrayOption}));
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        Assertions.assertFalse((boolean)arrayOption.hasValue());
        Assertions.assertNull((Object)arrayOption.getValue());
    }

    @Test
    public void testArrayOption6() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((Option)arrayOption);
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption7() throws ArgsSyntaxException {
        String[] stringArray = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption arrayOption = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TESTS) {
            System.out.println(arrayOption.toSynopsis());
        }
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)new AnyCondition(new Syntaxable[]{arrayOption}));
        argsParserImpl.withSyntaxNotation(SyntaxNotation.REFCODES);
        argsParserImpl.evalArgs(stringArray);
        if (IS_LOG_TESTS) {
            System.out.println(Arrays.toString(arrayOption.getValue()));
        }
        for (int i = 0; i < ((String[])arrayOption.getValue()).length; ++i) {
            Assertions.assertEquals((Object)stringArray[i * 2 + 1], (Object)((String[])arrayOption.getValue())[i]);
        }
        Assertions.assertEquals((int)(stringArray.length / 2), (int)((String[])arrayOption.getValue()).length);
    }

    @Test
    public void testOperation1() throws ArgsSyntaxException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{new AndCondition(new Syntaxable[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{"ls", "--verbose"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)xorCondition);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)operation.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        xorCondition.reset();
        stringArray = new String[]{"cd"};
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)operation2.isEnabled());
    }

    @Test
    public void testNone1() throws ArgsSyntaxException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        NoneOperand noneOperand = new NoneOperand("none", "No arguments at all");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{noneOperand, new AndCondition(new Syntaxable[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{"ls", "--verbose"};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)xorCondition);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertTrue((boolean)operation.isEnabled());
        Assertions.assertTrue((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        xorCondition.reset();
        stringArray = new String[]{"cd"};
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertTrue((boolean)operation2.isEnabled());
        Assertions.assertFalse((boolean)noneOperand.isEnabled());
    }

    @Test
    public void testNone2() throws ArgsSyntaxException {
        Operation operation = new Operation("ls", "List all entries");
        Operation operation2 = new Operation("cd", "Change direcory");
        NoneOperand noneOperand = new NoneOperand("none", "No arguments at all");
        VerboseFlag verboseFlag = new VerboseFlag();
        XorCondition xorCondition = new XorCondition(new Syntaxable[]{noneOperand, new AndCondition(new Syntaxable[]{operation, verboseFlag}), operation2});
        String[] stringArray = new String[]{};
        ArgsParserImpl argsParserImpl = new ArgsParserImpl((ArgsSyntax)xorCondition);
        argsParserImpl.evalArgs(stringArray);
        Assertions.assertFalse((boolean)operation.isEnabled());
        Assertions.assertFalse((boolean)verboseFlag.isEnabled());
        Assertions.assertFalse((boolean)operation2.isEnabled());
        Assertions.assertTrue((boolean)noneOperand.isEnabled());
    }

    private void testArgs(int n) throws ArgsSyntaxException {
        ArgsParserImpl argsParserImpl = new ArgsParserImpl();
        HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
        List list = argsParserImpl.evalArgs(ARGS[n]);
        for (Object object : list) {
            hashMap.put(object.getAlias(), (CallSite)((Object)("" + object.getValue())));
        }
        if (IS_LOG_TESTS) {
            System.out.println("Line <" + n + ">:");
        }
        for (Object object : hashMap.keySet()) {
            if (!IS_LOG_TESTS) continue;
            System.out.println((String)object + " := " + (String)hashMap.get(object));
        }
        Iterator<Object> iterator = PROPERTIES[n];
        for (int i = 0; i < ((Iterator<Object>)iterator).length; ++i) {
            PropertyImpl propertyImpl = new PropertyImpl(iterator[i]);
            if (((String)propertyImpl.getKey()).equals("null")) {
                propertyImpl = new PropertyImpl(null, (String)propertyImpl.getValue());
            }
            Assertions.assertEquals((Object)propertyImpl.getValue(), hashMap.get(propertyImpl.getKey()), (String)("Line <" + n + "> (" + propertyImpl.toString() + ")"));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ArgsParser argsParser, String[] stringArray) {
        ArgsSyntax argsSyntax = argsParser.getArgsSyntax();
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        argsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX).printHelp();
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.REFCODES + " SYNTAX NOTATION]  " + argsSyntax.toSynopsis(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[" + SyntaxNotation.GNU_POSIX + " SYNTAX NOTATION] " + argsSyntax.toSynopsis(SyntaxNotation.GNU_POSIX));
        }
        if (IS_LOG_TESTS) {
            System.out.println("[COMMAND LINE ARGS]         " + new VerboseTextBuilder().withElements((Object[])stringArray).toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("[INTERNAL STATUS]           " + argsSyntax.toString());
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(List<? extends Operand<?>> list) {
        if (IS_LOG_TESTS) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> operand : list) {
            if (!IS_LOG_TESTS) continue;
            System.out.println("[OPERAND] " + operand.toSyntax(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TESTS) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    static enum TrigonometricFunction {
        SINE,
        COSINE;

    }

    static enum SystemContext {
        S0,
        S1,
        S2;

    }

    static enum ChaosMode {
        X,
        Y,
        Z;

    }

    static enum BaseMetricsConfig {
        A,
        B,
        C;

    }
}

