/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.textual.VerboseTextBuilder;

public class XorCondition
extends AbstractCondition
implements Condition {
    private static final String OTHER_RIGHT_TAG = " }";
    private static final String OTHER_LEFT_TAG = "{ ";
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final String GUN_POSIX_XOR = " | ";
    private static final String LOGICAL_XOR = " ^ ";

    public XorCondition(Syntaxable ... aArgs) {
        super("Enforces that exactly one of the nested syntaxables must math from the arguments.", aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        ArrayList<ArgsSyntax> theOptionals = new ArrayList<ArgsSyntax>();
        List<Operand<?>> theResult = null;
        Syntaxable theResultSyntaxable = null;
        List<Operand<?>> eOperands = null;
        int theMatchCount = this.getChildren().size();
        for (Syntaxable eChild : this.getChildren()) {
            if (eChild instanceof AnyCondition) {
                theOptionals.add((AnyCondition)eChild);
            }
            try {
                eOperands = theResult != null && eChild instanceof Operand && theResultSyntaxable instanceof Option ? eChild.parseArgs(CliUtility.toDiff(aArgs, theResult), aOptions) : eChild.parseArgs(aArgs, aOptions);
                if (eOperands != null && eOperands.isEmpty()) {
                    eOperands = null;
                }
            }
            catch (ArgsSyntaxException ignore) {
                --theMatchCount;
            }
            if ((theResult = XorCondition.removeDuplicates(theResult, eOperands)) != null && eOperands != null) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match: " + new VerboseTextBuilder().withElements((Object[])CliUtility.toArgs(theResult, eOperands)).toString());
            }
            if (eOperands != null && !eOperands.isEmpty() && theResult == null) {
                theResult = eOperands;
                theResultSyntaxable = eChild;
            }
            eOperands = null;
        }
        if (theMatchCount == 0) {
            throw new UnknownArgsException(aArgs, "Not one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match!");
        }
        if (theMatchCount > 1) {
            if (theOptionals.size() > 1 && aArgs != null && aArgs.length > 0) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive optional syntax matched the provided command line arguments, causing exclusive contextual ambiguity: " + new VerboseTextBuilder().withElements(XorCondition.toSpec(theOptionals)).toString());
            }
            if ((theMatchCount -= theOptionals.size()) > 1) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match:");
            }
        }
        if (theResult != null) {
            return theResult;
        }
        if (theOptionals.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        throw new UnknownArgsException(aArgs, "Not one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match!");
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder(this.toSynopsis(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        if (theBuilder.length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.insert(0, LEFT_TAG);
            } else {
                theBuilder.insert(0, OTHER_LEFT_TAG);
            }
            if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.append(RIGHT_TAG);
            } else {
                theBuilder.append(OTHER_RIGHT_TAG);
            }
        }
        return theBuilder.toString();
    }

    @Override
    public String toSynopsis(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_XOR);
                } else {
                    theBuilder.append(GUN_POSIX_XOR);
                }
            }
            theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(LOGICAL_XOR);
            }
            theBuilder.append(eChild.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }

    private static List<String> toSpec(List<ArgsSyntax> aArgsSyntaxs) {
        ArrayList<String> theParameters = new ArrayList<String>();
        for (ArgsSyntax eArgsSyntax : aArgsSyntaxs) {
            for (Operand<?> eOperand : eArgsSyntax.toOperands()) {
                theParameters.add(CliUtility.toSpec(eOperand));
            }
        }
        return theParameters;
    }

    private static List<Operand<?>> removeDuplicates(List<Operand<?>> aElements, List<Operand<?>> aDuplicates) {
        if (aElements != null && aDuplicates != null) {
            for (Operand<?> eOperand : aDuplicates) {
                if (!aElements.contains(eOperand)) continue;
                aElements.remove(eOperand);
            }
            if (aElements.isEmpty()) {
                aElements = null;
            }
        }
        return aElements;
    }
}

