// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import java.util.List;

/**
 * This mixin provides builder additions (as of the builder pattern for chained
 * configuring method calls) for parsing command line arguments.
 */
public interface ArgsParserMixin<B extends ArgsParserMixin<B>> {

	/**
	 * Evaluates the provided command line arguments.
	 * 
	 * @param aArgs The command line arguments to be evaluated.
	 * 
	 * @return This instance as of the builder pattern to chain further method
	 *         calls.
	 * 
	 * @throws ArgsSyntaxException thrown in case of a command line arguments
	 *         mismatch regarding provided and expected args.
	 */
	B withEvalArgs( String[] aArgs ) throws ArgsSyntaxException;

	/**
	 * Evaluates the provided command line arguments .
	 * 
	 * @param aArgs The command line arguments to be evaluated.
	 * 
	 * @return This instance as of the builder pattern to chain further method
	 *         calls.
	 * 
	 * @throws ArgsSyntaxException thrown in case of a command line arguments
	 *         mismatch regarding provided and expected args.
	 */
	default B withEvalArgs( List<String> aArgs ) throws ArgsSyntaxException {
		return withEvalArgs( aArgs.toArray( new String[aArgs.size()] ) );
	}

}
