// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import org.refcodes.mixin.AbstractSchema;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.ValueAccessor;

/**
 * The purpose of a {@link CliSchema} is automatically generate documentation of
 * {@link Syntaxable} structures.
 */
public class CliSchema extends AbstractSchema<CliSchema> implements AliasAccessor, DescriptionAccessor, ValueAccessor<Object> {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Object _value = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public CliSchema( Class<?> aType, String aDescription, CliSchema... aChildren ) {
		super( aType, aDescription, aChildren );
	}

	/**
	 * {@inheritDoc}
	 */
	public CliSchema( Class<?> aType, String aAlias, String aDescription, CliSchema... aChildren ) {
		super( aType, aAlias, aDescription, aChildren );
	}

	/**
	 * {@inheritDoc}
	 */
	public CliSchema( Class<?> aType, String aAlias, String aDescription ) {
		super( aType, aAlias, aDescription );
	}

	/**
	 * {@inheritDoc}
	 */
	public CliSchema( Class<?> aType, String aDescription ) {
		super( aType, aDescription );
	}

	/**
	 * Instantiates a new {@link CliSchema}.
	 *
	 * @param aType the a type
	 * @param aDescription the a description
	 * @param aValue the a value
	 * @param aChildren the a children
	 */
	public CliSchema( Class<?> aType, String aDescription, Object aValue, CliSchema... aChildren ) {
		super( aType, aDescription, aChildren );
		_value = aValue;
	}

	/**
	 * Instantiates a new {@link CliSchema}.
	 *
	 * @param aType the a type
	 * @param aAlias the a alias
	 * @param aDescription the a description
	 * @param aValue the a value
	 * @param aChildren the a children
	 */
	public CliSchema( Class<?> aType, String aAlias, String aDescription, Object aValue, CliSchema... aChildren ) {
		super( aType, aAlias, aDescription, aChildren );
		_value = aValue;
		put( VALUE, aValue );
	}

	/**
	 * Instantiates a new {@link CliSchema}.
	 *
	 * @param aType the a type
	 * @param aAlias the a alias
	 * @param aDescription the a description
	 * @param aValue the a value
	 */
	public CliSchema( Class<?> aType, String aAlias, String aDescription, Object aValue ) {
		super( aType, aAlias, aDescription );
		_value = aValue;
		put( VALUE, aValue );
	}

	/**
	 * Instantiates a new {@link CliSchema}.
	 *
	 * @param aType the a type
	 * @param aDescription the a description
	 * @param aValue the a value
	 */
	public CliSchema( Class<?> aType, String aDescription, Object aValue ) {
		super( aType, aDescription );
		_value = aValue;
		put( VALUE, aValue );
	}

	/**
	 * {@inheritDoc}
	 */
	public CliSchema( CliSchema aSchema, CliSchema... aChildren ) {
		super( aSchema, aChildren );
	}

	/**
	 * {@inheritDoc}
	 */
	public CliSchema( CliSchema aSchema ) {
		super( aSchema );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return (String) get( DESCRIPTION );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAlias() {
		return (String) get( ALIAS );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getValue() {
		return _value;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

}