/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class OptionCondition
extends AbstractCondition
implements Condition {
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final char GUN_POSIX_NOP = '/';
    private static final String LOGICAL_NOP = " / ";

    public OptionCondition(Option<?> aArg) {
        super("A no-operation condition used to wrap an option in places where a condition is expected.", aArg);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        ArrayList theResult = new ArrayList();
        for (Syntaxable eChild : this.getChildren()) {
            List<? extends Operand<?>> eOperands;
            try {
                eOperands = eChild.parseArgs(aArgs, aOptions);
            }
            catch (UnknownArgsException exc) {
                throw new UnknownArgsException(exc.getArgs(), "At least one mandatory syntax did not match the provided command line arguments, though all mandatories must match.", (Throwable)((Object)exc));
            }
            catch (AmbiguousArgsException exc) {
                throw new AmbiguousArgsException(exc.getArgs(), "At least one mandatory syntax did not match the provided command line arguments, though all mandatories must match.", (Throwable)((Object)exc));
            }
            if (eOperands != null) {
                theResult.addAll(eOperands);
            }
            aArgs = CliUtility.toDiff(aArgs, eOperands);
        }
        return theResult;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_NOP);
                } else {
                    theBuilder.append('/');
                }
            }
            theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(LOGICAL_NOP);
            }
            theBuilder.append(eChild.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }
}

