/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.UnknownArgsException;

public class OrCondition
extends AbstractCondition
implements Condition {
    private static final String RIGHT_TAG = " )";
    private static final String LEFT_TAG = "( ";
    private static final String GNU_POSIX_OR = " ? ";
    private static final String LOGICAL_OR = " | ";

    public OrCondition(Syntaxable ... aArgs) {
        super("Enforces that at least one nested syntaxable must math from the arguments.", aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        ArrayList theResult = null;
        for (Syntaxable eChild : this.getChildren()) {
            try {
                List<? extends Operand<?>> eOperands = eChild.parseArgs(aArgs, aOptions);
                if (eOperands != null) {
                    if (theResult == null) {
                        theResult = new ArrayList();
                    }
                    theResult.addAll(eOperands);
                }
                aArgs = CliUtility.toDiff(aArgs, eOperands);
            }
            catch (AmbiguousArgsException | UnknownArgsException argsSyntaxException) {}
        }
        if (theResult != null) {
            return theResult;
        }
        throw new UnknownArgsException(aArgs, "Not any syntax matched the provided command line arguments, though at least one elective must match.");
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                theBuilder.append(LOGICAL_OR);
            } else {
                theBuilder.append(GNU_POSIX_OR);
            }
            theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }

    @Override
    public String toSynopsis(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() != 0) {
                if (aSyntaxNotation == SyntaxNotation.REFCODES) {
                    theBuilder.append(LOGICAL_OR);
                } else {
                    theBuilder.append(GNU_POSIX_OR);
                }
            }
            theBuilder.append(eChild.toSyntax(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        }
        return theBuilder.toString();
    }

    @Override
    public String toState() {
        StringBuilder theBuilder = new StringBuilder();
        for (Syntaxable eChild : this.getChildren()) {
            if (theBuilder.length() == 0) {
                theBuilder.append(LEFT_TAG);
            } else {
                theBuilder.append(LOGICAL_OR);
            }
            theBuilder.append(eChild.toState());
        }
        if (theBuilder.length() != 0) {
            theBuilder.append(RIGHT_TAG);
        }
        return theBuilder.toString();
    }
}

