/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.cli.AbstractSyntaxable;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Synopsisable;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;

public abstract class AbstractCondition
extends AbstractSyntaxable
implements Condition {
    private List<Syntaxable> _children = new ArrayList<Syntaxable>();
    private String _description;

    public AbstractCondition(String aDescription, Syntaxable ... aElements) {
        this._children.addAll(Arrays.asList(aElements));
        this._description = aDescription;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder(this.toSynopsis(aSyntaxNotation, aOptEscCode, aParamEscCode, aResetEscCode));
        if (theBuilder.length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            theBuilder.insert(0, "( ");
            theBuilder.append(" )");
        }
        return theBuilder.toString();
    }

    public void reset() {
        for (Syntaxable eSyntaxable : this._children) {
            eSyntaxable.reset();
        }
    }

    public String toString() {
        String theState = this.toState();
        if (theState != null && theState.length() >= 4 && theState.startsWith("( ") && theState.endsWith(" )")) {
            theState = theState.substring(2).substring(0, theState.length() - 4);
        }
        return theState;
    }

    public CliSchema toSchema() {
        CliSchema[] theSchemas = null;
        if (this._children != null && this._children.size() != 0) {
            theSchemas = new CliSchema[this._children.size()];
            int i = 0;
            while (i < theSchemas.length) {
                theSchemas[i] = (CliSchema)this._children.get(i).toSchema();
                ++i;
            }
        }
        return new CliSchema(this.getClass(), this._description, theSchemas);
    }

    public List<Operand<?>> toOperands() {
        ArrayList theList = new ArrayList();
        for (Synopsisable synopsisable : this.getChildren()) {
            if (synopsisable instanceof Operand) {
                theList.add((Operand)synopsisable);
            }
            if (!(synopsisable instanceof ArgsSyntax)) continue;
            theList.addAll(((ArgsSyntax)synopsisable).toOperands());
        }
        return theList;
    }

    protected List<Syntaxable> getChildren() {
        return this._children;
    }

    protected Syntaxable getFirst() {
        return this._children.get(0);
    }

    protected void addChild(Syntaxable aArgumentizer) {
        this._children.add(aArgumentizer);
    }

    @Override
    public <V> V toValue(String aAlias) {
        for (Syntaxable eElement : this._children) {
            Object eValue = eElement.toValue(aAlias);
            if (eValue == null) continue;
            return eValue;
        }
        return null;
    }

    @Override
    public <T extends Operand<?>> T toOperand(String aAlias, Class<T> aType) {
        for (Syntaxable eSyntaxable : this.getChildren()) {
            ArgsSyntax eCondition;
            Operand eOperand;
            if (eSyntaxable instanceof Operand) {
                eOperand = (Operand)eSyntaxable;
                boolean eTypeMatch = true;
                boolean eAliasMatch = true;
                if (aAlias != null && aAlias.length() != 0) {
                    eAliasMatch = aAlias.equals(eOperand.getAlias());
                }
                if (aType != null) {
                    eTypeMatch = aType.isAssignableFrom(eOperand.getClass());
                }
                if (!eTypeMatch || !eAliasMatch) continue;
                return (T)eOperand;
            }
            if (!(eSyntaxable instanceof ArgsSyntax) || (eOperand = (eCondition = (ArgsSyntax)eSyntaxable).toOperand(aAlias, aType)) == null) continue;
            return (T)eOperand;
        }
        return null;
    }
}

