/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.refcodes.cli.ArgsParserMixin;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.Example;
import org.refcodes.cli.Operand;
import org.refcodes.cli.RootConditionAccessor;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.mixin.DescriptionAccessor;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.mixin.Resetable;
import org.refcodes.mixin.TitleAccessor;
import org.refcodes.textual.Font;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxGridAccessor;

public interface ArgsParser
extends ArgsParserMixin<ArgsParser>,
TitleAccessor.TitleProperty,
TitleAccessor.TitleBuilder<ArgsParser>,
NameAccessor.NameProperty,
NameAccessor.NameBuilder<ArgsParser>,
DescriptionAccessor.DescriptionProperty,
DescriptionAccessor.DescriptionBuilder<ArgsParser>,
Resetable,
RootConditionAccessor,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<ArgsParser>,
ResetEscapeCodeAccessor.ResetEscapeCodeProperty,
ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<ArgsParser>,
TextBoxGridAccessor.TextBoxGridProperty,
TextBoxGridAccessor.TextBoxGridBuilder<ArgsParser> {
    public void errorLn(String var1);

    default public List<? extends Operand<?>> evalArgs(List<String> aArgs) throws ArgsSyntaxException {
        return this.evalArgs(aArgs.toArray(new String[aArgs.size()]));
    }

    public List<? extends Operand<?>> evalArgs(String[] var1) throws ArgsSyntaxException;

    public String getCopyrightNote();

    public String getDescription();

    public String getLicenseNote();

    public String getCommandEscapeCode();

    public String getDescriptionEscapeCode();

    public String getParamEscapeCode();

    public String getOptionEscapeCode();

    public String getBannerEscapeCode();

    public String getLineSeparatorEscapeCode();

    public char getSeparatorLnChar();

    public String getBannerBorderEscapeCode();

    @Override
    public ArgsSyntax getArgsSyntax();

    public List<Example> getExamples();

    default public void addExample(String aDescription, Operand<?> ... aOperands) {
        this.addExample(new Example(aDescription, aOperands));
    }

    public void addExample(Example var1);

    default public ArgsParser withExample(Example aExample) {
        this.addExample(aExample);
        return this;
    }

    default public ArgsParser withExample(String aDescription, Operand<?> ... aOperands) {
        this.addExample(aDescription, aOperands);
        return this;
    }

    default public ArgsParser withExamples(Collection<Example> aExamples) {
        for (Example eExample : aExamples) {
            this.addExample(eExample);
        }
        return this;
    }

    default public ArgsParser withExamples(Example[] aExamples) {
        Example[] exampleArray = aExamples;
        int n = aExamples.length;
        int n2 = 0;
        while (n2 < n) {
            Example eExample = exampleArray[n2];
            this.addExample(eExample);
            ++n2;
        }
        return this;
    }

    public void printHeader();

    public void printBanner();

    default public void printBody() {
        if (this.getLicenseNote() != null) {
            this.printLicenseNote();
            this.printSeparatorLn();
        }
        this.printSynopsis();
        this.printSeparatorLn();
        if (this.getDescription() != null) {
            this.printDescription();
            this.printSeparatorLn();
        }
        if (this.getArgsSyntax() != null) {
            this.printOptions();
            this.printSeparatorLn();
        }
        if (this.getExamples() != null && this.getExamples().size() != 0) {
            this.printExamples();
            this.printSeparatorLn();
        }
        if (this.getCopyrightNote() != null) {
            this.printCopyrightNote();
            this.printSeparatorLn();
        }
    }

    public void printCopyrightNote();

    public void printDescription();

    public void printExamples();

    default public void printHelp() {
        this.printBanner();
        this.printBody();
    }

    public void printLicenseNote();

    public void printLn();

    public void printLn(String var1);

    public void printOptions();

    public void printSeparatorLn();

    public void printSynopsis();

    public void setBannerFont(Font var1);

    public void setBannerFontPalette(char[] var1);

    public void setConsoleWidth(int var1);

    public void setCopyrightNote(String var1);

    public void setErrorOut(PrintStream var1);

    public void setLicenseNote(String var1);

    public void setLineBreak(String var1);

    public void setMaxConsoleWidth(int var1);

    public void setDescriptionEscapeCode(String var1);

    public void setCommandEscapeCode(String var1);

    public void setParamEscapeCode(String var1);

    public void setOptionEscapeCode(String var1);

    public void setBannerEscapeCode(String var1);

    public void setLineSeparatorEscapeCode(String var1);

    public void setBannerBorderEscapeCode(String var1);

    public void setSeparatorLnChar(char var1);

    public void setStandardOut(PrintStream var1);

    public void setSyntaxNotation(SyntaxNotation var1);

    default public ArgsParser withTextBoxGrid(TextBoxGrid aTextBoxGrid) {
        this.setTextBoxGrid(aTextBoxGrid);
        return this;
    }

    default public ArgsParser withBannerFont(Font aBannerFont) {
        this.setBannerFont(aBannerFont);
        return this;
    }

    default public ArgsParser withBannerFontPalette(char[] aColorPalette) {
        this.setBannerFontPalette(aColorPalette);
        return this;
    }

    default public ArgsParser withConsoleWidth(int aConsoleWidth) {
        this.setConsoleWidth(aConsoleWidth);
        return this;
    }

    default public ArgsParser withCopyrightNote(String aCopyrightNote) {
        this.setCopyrightNote(aCopyrightNote);
        return this;
    }

    default public ArgsParser withDescription(String aDescription) {
        this.setDescription(aDescription);
        return this;
    }

    default public ArgsParser withErrorOut(PrintStream aErrorOut) {
        this.setErrorOut(aErrorOut);
        return this;
    }

    default public ArgsParser withEscapeCodesEnabled(boolean isEscCodeEnabled) {
        this.setEscapeCodesEnabled(isEscCodeEnabled);
        return this;
    }

    @Override
    default public ArgsParser withEvalArgs(List<String> aArgs) throws ArgsSyntaxException {
        this.evalArgs(aArgs.toArray(new String[aArgs.size()]));
        return this;
    }

    default public ArgsParser withLicenseNote(String aLicenseNote) {
        this.setLicenseNote(aLicenseNote);
        return this;
    }

    default public ArgsParser withLineBreak(String aLineBreak) {
        this.setLineBreak(aLineBreak);
        return this;
    }

    default public ArgsParser withMaxConsoleWidth(int aMaxConsoleWidth) {
        this.setMaxConsoleWidth(aMaxConsoleWidth);
        return this;
    }

    default public ArgsParser withName(String aName) {
        this.setName(aName);
        return this;
    }

    default public ArgsParser withDescriptionEscapeCode(String aDescriptionEscCode) {
        this.setDescriptionEscapeCode(aDescriptionEscCode);
        return this;
    }

    default public ArgsParser withCommandEscapeCode(String aCommandEscCode) {
        this.setCommandEscapeCode(aCommandEscCode);
        return this;
    }

    default public ArgsParser withParamEscapeCode(String aParamEscCode) {
        this.setParamEscapeCode(aParamEscCode);
        return this;
    }

    default public ArgsParser withOptionEscapeCode(String aOptEscCode) {
        this.setParamEscapeCode(aOptEscCode);
        return this;
    }

    default public ArgsParser withBannerEscapeCode(String aBannerEscCode) {
        this.setBannerEscapeCode(aBannerEscCode);
        return this;
    }

    default public ArgsParser withLineSeparatorEscapeCode(String aLineSeparatorEscCode) {
        this.setLineSeparatorEscapeCode(aLineSeparatorEscCode);
        return this;
    }

    default public ArgsParser withBannerBorderEscapeCode(String aBannerBorderEscCode) {
        this.setBannerEscapeCode(aBannerBorderEscCode);
        return this;
    }

    @Override
    default public ArgsParser withEvalArgs(String[] aArgs) throws ArgsSyntaxException {
        this.evalArgs(aArgs);
        return this;
    }

    default public ArgsParser withResetEscapeCode(String aResetEscCode) {
        this.setResetEscapeCode(aResetEscCode);
        return this;
    }

    default public ArgsParser withSeparatorLnChar(char aSeparatorLnChar) {
        this.setSeparatorLnChar(aSeparatorLnChar);
        return this;
    }

    default public ArgsParser withStandardOut(PrintStream aStandardOut) {
        this.setStandardOut(aStandardOut);
        return this;
    }

    default public ArgsParser withSyntaxNotation(SyntaxNotation aSyntaxNotation) {
        this.setSyntaxNotation(aSyntaxNotation);
        return this;
    }

    default public ArgsParser withTitle(String aTitle) {
        this.setTitle(aTitle);
        return this;
    }
}

