/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArrayOperand;
import org.refcodes.cli.Flag;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.Syntaxable;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public final class CliUtility {
    private CliUtility() {
    }

    public static boolean contains(String[] aArgs, String aArg) {
        ArrayList<String> theList = new ArrayList<String>(Arrays.asList(aArgs));
        return theList.contains(aArg);
    }

    public static boolean isOptionArgument(String aArg) {
        int i = 0;
        while (i < CommandArgPrefix.toPrefixes().length) {
            if (aArg.startsWith(CommandArgPrefix.toPrefixes()[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Relation<String, String> getOptionArgument(Option<?> aOption, String[] aArgs, String[] aOptions) {
        if (aArgs.length < 2) {
            return null;
        }
        Relation<String, String> theAttribute = CliUtility.getOptionArgument(aArgs, aOption.getShortOption(), aOptions);
        if (theAttribute != null) {
            return theAttribute;
        }
        theAttribute = CliUtility.getOptionArgument(aArgs, aOption.getLongOption(), aOptions);
        if (theAttribute != null) {
            return theAttribute;
        }
        return null;
    }

    @SafeVarargs
    public static String[] toArgs(List<? extends Operand<?>> ... aOperands) {
        if (aOperands != null) {
            ArrayList<String> theArgs = new ArrayList<String>();
            List<? extends Operand<?>>[] listArray = aOperands;
            int n = aOperands.length;
            int n2 = 0;
            while (n2 < n) {
                List<Operand<?>> eOperands = listArray[n2];
                if (eOperands != null) {
                    for (Operand<?> eOperand : eOperands) {
                        if (eOperand.getArgs() == null) continue;
                        theArgs.addAll(Arrays.asList(eOperand.getArgs()));
                    }
                }
                ++n2;
            }
            return theArgs.toArray(new String[theArgs.size()]);
        }
        return null;
    }

    public static String[] toDiff(String[] aSet, String[] aSubset) {
        ArrayList<String> theDiff = new ArrayList<String>(Arrays.asList(aSet));
        int index = 0;
        String[] stringArray = aSubset;
        int n = aSubset.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String eeElement;
                String eElement = stringArray[n2];
                int l = index;
                while (l < theDiff.size()) {
                    eeElement = (String)theDiff.get(l);
                    if (eElement.equals(eeElement)) {
                        theDiff.remove(l);
                        index = l;
                        break block5;
                    }
                    ++l;
                }
                l = 0;
                while (l < theDiff.size()) {
                    eeElement = (String)theDiff.get(l);
                    if (eElement.equals(eeElement)) {
                        theDiff.remove(l);
                        index = l;
                        break;
                    }
                    ++l;
                }
            }
            ++n2;
        }
        return theDiff.toArray(new String[theDiff.size()]);
    }

    public static String[] toDiff(String[] aSet, List<? extends Operand<?>> aSubset) {
        String[] theSubset = CliUtility.toArgs(aSubset);
        return CliUtility.toDiff(aSet, theSubset);
    }

    public static String toParameterSpec(Operand<?> aOperand) {
        if (aOperand instanceof ArrayOperand) {
            ArrayOperand theArrayOperand = (ArrayOperand)aOperand;
            return CliUtility.toParameterSpec(aOperand, theArrayOperand.getMinLength(), theArrayOperand.getMaxLength(), null, null);
        }
        return CliUtility.toParameterSpec(aOperand, -1, -1, null, null);
    }

    public static String toParameterSpec(Operand<?> aOperand, String aParamEscCode, String aResetEscCode) {
        if (aOperand instanceof ArrayOperand) {
            ArrayOperand theArrayOperand = (ArrayOperand)aOperand;
            return CliUtility.toParameterSpec(aOperand, theArrayOperand.getMinLength(), theArrayOperand.getMaxLength(), aParamEscCode, aResetEscCode);
        }
        return CliUtility.toParameterSpec(aOperand, -1, -1, aParamEscCode, aResetEscCode);
    }

    public static String toParameterSpec(Operand<?> aOperand, int aMin, int aMax) {
        return CliUtility.toParameterSpec(aOperand, aMin, aMax, null, null);
    }

    public static String toParameterSpec(Operand<?> aOperand, int aMin, int aMax, String aParamEscCode, String aResetEscCode) {
        aParamEscCode = aParamEscCode == null ? "" : aParamEscCode;
        String string = aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        if (aOperand.getAlias() == null) {
            return "";
        }
        StringBuilder theBuilder = new StringBuilder();
        if (!(aOperand instanceof Flag) && aOperand.getAlias() != null) {
            if (aOperand instanceof Option) {
                theBuilder.append('<');
            }
            theBuilder.append(String.valueOf(aParamEscCode) + (aOperand instanceof NoneOperand ? aOperand.toState() : aOperand.getAlias()) + aResetEscCode);
            if (aOperand.getType().isArray()) {
                theBuilder.append("[");
            } else if (aMin != -1 || aMax != -1) {
                theBuilder.append("{");
            }
            if (aMin != -1 && aMin == aMax) {
                theBuilder.append(aMin);
            } else {
                if (aMin != -1) {
                    theBuilder.append(aMin);
                }
                if (aOperand.getType().isArray() || aMin != -1 || aMax != -1) {
                    theBuilder.append("...");
                }
                if (aMax != -1) {
                    theBuilder.append(aMax);
                }
            }
            if (aOperand.getType().isArray()) {
                theBuilder.append("]");
            } else if (aMin != -1 || aMax != -1) {
                theBuilder.append("}");
            }
            if (aOperand instanceof Option) {
                theBuilder.append('>');
            }
        }
        return theBuilder.toString();
    }

    public static String toShortSpec(Operand<?> aOperand) {
        return CliUtility.toShortSpec(aOperand, null, null, null);
    }

    public static String toShortSpec(Operand<?> aOperand, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(CliUtility.toShortOptionsSpec(aOperand, aOptEscCode, aResetEscCode));
        String theParameterSpec = CliUtility.toParameterSpec(aOperand, aParamEscCode, aResetEscCode);
        if (theParameterSpec != null && theParameterSpec.length() != 0 && theBuilder.length() > 0) {
            theBuilder.append(' ');
        }
        theBuilder.append(theParameterSpec);
        return theBuilder.toString();
    }

    public static String toShortOptionsSpec(Operand<?> aOperand) {
        return CliUtility.toShortOptionsSpec(aOperand, null, null);
    }

    public static String toShortOptionsSpec(Operand<?> aOperand, String aOptEscCode, String aResetEscCode) {
        aOptEscCode = aOptEscCode == null ? "" : aOptEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        StringBuilder theBuilder = new StringBuilder();
        if (aOperand instanceof Option) {
            Option eOption = (Option)aOperand;
            if (eOption.getShortOption() != null) {
                theBuilder.append(String.valueOf(aOptEscCode) + eOption.getShortOption() + aResetEscCode);
            } else if (eOption.getLongOption() != null) {
                if (theBuilder.length() > 0) {
                    theBuilder.append(' ');
                }
                theBuilder.append(String.valueOf(aOptEscCode) + eOption.getLongOption() + aResetEscCode);
            }
        }
        return theBuilder.toString();
    }

    public static String toOptionsSpec(Operand<?> aOperand) {
        return CliUtility.toOptionsSpec(aOperand, null, null);
    }

    public static String toOptionsSpec(Operand<?> aOperand, String aOptEscCode, String aResetEscCode) {
        aOptEscCode = aOptEscCode == null ? "" : aOptEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        StringBuilder theBuilder = new StringBuilder();
        if (aOperand instanceof Option) {
            Option eOption = (Option)aOperand;
            if (eOption.getShortOption() != null) {
                theBuilder.append(String.valueOf(aOptEscCode) + eOption.getShortOption() + aResetEscCode);
            }
            if (eOption.getLongOption() != null) {
                if (theBuilder.length() > 0) {
                    theBuilder.append(' ');
                }
                theBuilder.append(String.valueOf(aOptEscCode) + eOption.getLongOption() + aResetEscCode);
            }
        }
        return theBuilder.toString();
    }

    public static String toSpec(Operand<?> aOperand) {
        return CliUtility.toSpec(aOperand, null, null, null);
    }

    public static String toSpec(Operand<?> aOperand, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        StringBuilder theBuilder = new StringBuilder();
        theBuilder.append(CliUtility.toOptionsSpec(aOperand, aOptEscCode, aResetEscCode));
        String theParameterSpec = CliUtility.toParameterSpec(aOperand, aParamEscCode, aResetEscCode);
        if (theParameterSpec != null && theParameterSpec.length() != 0 && theBuilder.length() > 0) {
            theBuilder.append(' ');
        }
        theBuilder.append(theParameterSpec);
        return theBuilder.toString();
    }

    static String[] toOptions(Syntaxable aSyntaxable) {
        HashSet<String> theOptions = new HashSet<String>();
        if (aSyntaxable instanceof ArgsSyntax) {
            ArgsSyntax theArgsSyntax = (ArgsSyntax)aSyntaxable;
            for (Operand<?> eOperand : theArgsSyntax.toOperands()) {
                String[] eOptions = CliUtility.toOptions(eOperand);
                if (eOptions == null || eOptions.length == 0) continue;
                theOptions.addAll(Arrays.asList(eOptions));
            }
        }
        if (aSyntaxable instanceof Option) {
            Option theOption = (Option)aSyntaxable;
            if (theOption.getShortOption() != null && theOption.getShortOption().length() != 0) {
                theOptions.add(theOption.getShortOption());
            }
            if (theOption.getLongOption() != null && theOption.getLongOption().length() != 0) {
                theOptions.add(theOption.getLongOption());
            }
        }
        return theOptions.toArray(new String[theOptions.size()]);
    }

    private static Relation<String, String> getOptionArgument(String[] args, String aOption, String[] aOptions) {
        int i = 0;
        while (i < args.length - 1) {
            String eArg = args[i];
            if (eArg.equals(aOption)) {
                String eOptArg = args[i + 1];
                String[] stringArray = aOptions;
                int n = aOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    String eOption = stringArray[n2];
                    if (eOptArg.equalsIgnoreCase(eOption)) {
                        return null;
                    }
                    ++n2;
                }
                return new RelationImpl((Object)aOption, (Object)eOptArg);
            }
            ++i;
        }
        return null;
    }
}

