/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.mixin.EnabledAccessor;

public class Operation
extends AbstractOperand<Boolean>
implements EnabledAccessor {
    private String _operation;

    public Operation(String aOperation, String aDescription) {
        this(aOperation, aOperation, aDescription);
    }

    public Operation(String aOperation, String aAlias, String aDescription) {
        super(Boolean.class, aAlias, aDescription);
        if (aOperation == null) {
            throw new IllegalArgumentException("The operation argument must not be null!");
        }
        if (aOperation.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()) | aOperation.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your operation \"" + aOperation + "\" must not start with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\" or \"" + CommandArgPrefix.POSIX_LONG_OPTION.getPrefix() + "\" as if it were an option.");
        }
        this._operation = aOperation;
    }

    public boolean isEnabled() {
        Boolean theValue = (Boolean)this.getValue();
        if (theValue != null) {
            return theValue;
        }
        return false;
    }

    @Override
    public List<Operand<Boolean>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        boolean hasOperation;
        block4: {
            if (aArgs != null) {
                int i = 0;
                while (i < aArgs.length) {
                    if (this.getOperation().equals(aArgs[i])) {
                        hasOperation = true;
                        break block4;
                    }
                    ++i;
                }
            }
            hasOperation = false;
        }
        if (hasOperation) {
            ArrayList<Operand<Boolean>> theList = new ArrayList<Operand<Boolean>>();
            theList.add(this);
            this.setArgs(new String[]{this.getOperation()});
            this.setValue(true);
            return theList;
        }
        throw new UnknownArgsException(aArgs, "The operation \"" + this.getOperation() + "\" was found in the command line arguments.");
    }

    public String getOperation() {
        return this._operation;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        aOptEscCode = aOptEscCode == null ? "" : aOptEscCode;
        aParamEscCode = aParamEscCode == null ? "" : aParamEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        return String.valueOf(aOptEscCode) + this.getOperation() + (this.getAlias() != null ? " " + CliUtility.toParameterSpec(this, aParamEscCode, aResetEscCode) : "") + aResetEscCode;
    }

    @Override
    public void reset() {
        super.reset();
        super.setValue(false);
    }

    @Override
    protected Boolean toType(String aArg) throws ParseArgsException {
        throw new UnsupportedOperationException("*** NOT REQUIRED BY THIS IMPLEMENTATION ***");
    }
}

