/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AllCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArgsSyntax;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.OrCondition;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Syntaxable;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");
    private static String[][] ARGS = new String[][]{{"--name", "FILE", "--boolean", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static String[][] PROPERTIES = new String[][]{{"name=FILE", "boolean=true", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testEdgeCase1() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        ArgsSyntax theArgsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theInputFileArg, theOutputFileArg, CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{theHelpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{theSysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerboseFlag})})})});
        ArgsParserImpl theParser = new ArgsParserImpl(theArgsSyntax);
        theParser.evalArgs(new String[]{"-i", "in", "-o", "out"});
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArgsSyntax.toSchema());
        }
    }

    @Test
    public void testEdgeCase2() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        ArgsSyntax theArgsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theInputFileArg, theOutputFileArg, CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{theHelpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{theSysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerboseFlag})})})});
        ArgsParserImpl theParser = new ArgsParserImpl(theArgsSyntax);
        try {
            theParser.evalArgs(new String[0]);
            Assertions.fail((String)("Expected an <" + UnknownArgsException.class.getName() + ">!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeCase3() throws ArgsSyntaxException {
        EnumOption theEncodingArg = CliSugar.enumOption((String)"--encoding", BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])BaseMetricsConfig.values())));
        Flag theBase64Flag = CliSugar.flag((String)"--base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag theDecryptFlag = CliSugar.flag((String)"-d", (String)"--decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the message (stream, file, text or bytes).");
        Flag theEncryptFlag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
        Flag theVerifyFlag = CliSugar.flag((String)"--verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption theLineWidthArg = CliSugar.intOption((String)"--line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        StringOption theInputFileArg = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        ArgsSyntax theArgsSyntax = CliSugar.and((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theEncryptFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerifyFlag, CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theBase64Flag, CliSugar.any((Syntaxable[])new Syntaxable[]{theLineWidthArg})}), CliSugar.and((Syntaxable[])new Syntaxable[]{theEncodingArg, CliSugar.any((Syntaxable[])new Syntaxable[]{theLineWidthArg})})})})}), theDecryptFlag}), CliSugar.any((Syntaxable[])new Syntaxable[]{theInputFileArg, theOutputFileArg})});
        String[] args = new String[]{"-e", "-i", "input.dat", "-o", "output.txt"};
        ArgsParserImpl theParser = new ArgsParserImpl(theArgsSyntax);
        theParser.evalArgs(args);
    }

    @Test
    public void testEdgeCase4() throws ArgsSyntaxException {
        EnumOption theChaosModeArg = CliSugar.enumOption((String)"--chaos-mode", ChaosMode.class, (String)"CHAOS_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption theContextArg = CliSugar.enumOption((String)"--context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag thePromptPasswordFlag = CliSugar.flag((String)"--prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        StringOption theCertFileArg = CliSugar.stringOption((String)"-c", (String)"--cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption thePasswordArg = CliSugar.stringOption((String)"-p", (String)"--password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        ArgsSyntax theArgsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{thePromptPasswordFlag, thePasswordArg, theContextArg}), theChaosModeArg}), CliSugar.and((Syntaxable[])new Syntaxable[]{theCertFileArg, CliSugar.any((Syntaxable[])new Syntaxable[]{CliSugar.xor((Syntaxable[])new Syntaxable[]{thePromptPasswordFlag, thePasswordArg, theContextArg})})})})});
        String[] args = new String[]{"-p", "Hallo Welt!", "--cert-file", "C"};
        ArgsParserImpl theParser = new ArgsParserImpl(theArgsSyntax);
        theParser.evalArgs(args);
    }

    @Test
    public void testEdgeCase5() throws ArgsSyntaxException {
        StringOption theEchoOption = CliSugar.stringOption((String)"-e", (String)"--echo", (String)"TEXT_PROPERTY", (String)"Echoes the provided message to the standard out stream.");
        ConfigOption theConfigOption = CliSugar.configOption();
        InitFlag theInitFlag = CliSugar.initFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag();
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        ArgsSyntax theArgsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theEchoOption, CliSugar.any((Syntaxable[])new Syntaxable[]{theConfigOption, theVerboseFlag, theDebugFlag})}), CliSugar.and((Syntaxable[])new Syntaxable[]{theInitFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theConfigOption, theVerboseFlag})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{theHelpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{theSysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerboseFlag})})})});
        String[] args = new String[]{};
        ArgsParserImpl theParser = new ArgsParserImpl(theArgsSyntax);
        try {
            theParser.evalArgs(args);
            Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getSimpleName() + "> exception!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgCase6() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((String)"-i", (String)"--input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((String)"-o", (String)"--output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        ArgsSyntax theArgsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theInputFileArg, CliSugar.and((Syntaxable[])new Syntaxable[]{theOutputFileArg, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerboseFlag})}), theDebugFlag}), CliSugar.and((Syntaxable[])new Syntaxable[]{theInputFileArg, CliSugar.and((Syntaxable[])new Syntaxable[]{theDebugFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerboseFlag})})}), CliSugar.xor((Syntaxable[])new Syntaxable[]{theHelpFlag, CliSugar.and((Syntaxable[])new Syntaxable[]{theSysInfoFlag, CliSugar.any((Syntaxable[])new Syntaxable[]{theVerboseFlag})})})});
        String[] args = new String[]{"-i", "someInputFile"};
        ArgsParserImpl theParser = new ArgsParserImpl(theArgsSyntax);
        theParser.evalArgs(args);
    }

    @Test
    public void testAnyCase1() {
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{};
        ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)theDebugFlag.isEnabled());
        Assertions.assertFalse((boolean)theVerboseFlag.isEnabled());
        Assertions.assertFalse((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase2() {
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{"-q"};
        ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)theDebugFlag.isEnabled());
        Assertions.assertFalse((boolean)theVerboseFlag.isEnabled());
        Assertions.assertTrue((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase3() {
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{"-d", "-v"};
        ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)theDebugFlag.isEnabled());
        Assertions.assertTrue((boolean)theVerboseFlag.isEnabled());
        Assertions.assertFalse((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase4() {
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{"-d"};
        ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)theDebugFlag.isEnabled());
        Assertions.assertFalse((boolean)theVerboseFlag.isEnabled());
        Assertions.assertFalse((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase5() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-q", "-d"};
            ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.getMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase6() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-v", "-q"};
            ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.getMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase7() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            ArgsSyntax theRoot = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-d", "-v", "-q"};
            ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.getMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyXor1() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            ArgsSyntax theRoot = CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.any((Syntaxable[])new Syntaxable[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-q", "-d"};
            ArgsParserImpl theParser = new ArgsParserImpl(theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + AmbiguousArgsException.class.getName() + "> exception!"));
            }
            catch (AmbiguousArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.getMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testParser1() throws ArgsSyntaxException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser2() throws ArgsSyntaxException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AnyCondition theOptional = new AnyCondition(new Syntaxable[]{theXor});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theOptional, theFile});
        String[] args = new String[]{"-f", "someFile", "-d"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theAnd.toSynopsis());
        }
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertFalse((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser3() throws ArgsSyntaxException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser4() throws ArgsSyntaxException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser5() throws ArgsSyntaxException {
        StringOption theFile = new StringOption("-f", "--file", "file", "The file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException e) {
            Assertions.assertEquals((int)1, (int)e.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)e.getArgs()[0]);
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser6() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser7() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser8() {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theDelete, theAdd});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theOperand, theXor, theFromFile, theToFile});
        List theList = theAnd.toOperands();
        Collections.sort(theList);
        this.doLogOperands(theList);
    }

    @Test
    public void testParser9() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption("-f", "--from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption theToFile = new StringOption("-t", "--to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag("-a", null, null, "Add the specified file");
        Flag theCreate = new Flag("-c", null, null, "Creates the specified file");
        OrCondition theOrArgsSyntax = new OrCondition(new Syntaxable[]{theAdd, theCreate});
        Flag theDelete = new Flag("-d", null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theOrArgsSyntax, theDelete});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption("-f", "--from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOption theToFile = new StringOption("-t", "--to", "to", "The destination file to be processed");
        Flag theAddFile = new Flag("-a", "--add", "add", "Add the specified file");
        Flag theCreateFile = new Flag("-c", "--create", "create", "Creates the specified file");
        OrCondition theOrArgsSyntax = new OrCondition(new Syntaxable[]{theAddFile, theCreateFile});
        Flag theDeleteFile = new Flag("-d", "--delete", "delete", "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Syntaxable[]{theOrArgsSyntax, theDeleteFile});
        AndCondition theAnd = new AndCondition(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theAnd);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theAnd.toSynopsis());
        }
        theArgsParser.evalArgs(args);
        String theFrom = (String)theAnd.toValue("from");
        String theTo = (String)theAnd.toValue("to");
        boolean theAdd = (Boolean)theAnd.toValue("add");
        boolean theCreate = (Boolean)theAnd.toValue("create");
        boolean theDelete = (Boolean)theAnd.toValue("delete");
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("From := " + theFrom);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("To := " + theTo);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Add := " + theAdd);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Create := " + theCreate);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Delete := " + theDelete);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)theFrom);
        Assertions.assertEquals((Object)"toFile", (Object)theTo);
        Assertions.assertTrue((boolean)theAdd);
        Assertions.assertFalse((boolean)theCreate);
        Assertions.assertFalse((boolean)theDelete);
    }

    @Test
    public void testArgsProperties() throws ArgsSyntaxException {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Test
    public void testProductionError() throws ArgsSyntaxException {
        String[] args = new String[]{"-l", "1", "-s", "100", "-f", "1"};
        DoubleOption theFrequencyOpt = CliSugar.doubleOption((String)"-f", (String)"--frequency", (String)"FREQUENCY_HZ", (String)"The frequency (Hz) to use when generating the values.");
        IntOption theSamplingRateOpt = CliSugar.intOption((String)"-s", (String)"--sampling-rate", (String)"SAMPLING_RATE", (String)"The sample rate (per second) for the generated values (defaults to DEFAULT_SAMPLING_RATE_PER_SEC samples/second).");
        DoubleOption theLengthOpt = CliSugar.doubleOption((String)"-l", (String)"--length", (String)"LENGTH_SEC", (String)"The length (in seconds) for the generated values (defaults to DFAULT_LENGTH_SEC seconds).");
        ArgsSyntax theRoot = CliSugar.and((Syntaxable[])new Syntaxable[]{theFrequencyOpt, CliSugar.any((Syntaxable[])new Syntaxable[]{theLengthOpt, theSamplingRateOpt})});
        ArgsParserImpl theArgsParser = new ArgsParserImpl(theRoot);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.withName("Waves").withTitle("~waves~").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        theArgsParser.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        theArgsParser.withDescription("Generate (sound) wave tables for given frequencies and amplitudes. Export them as CSV for further processing. Makes heavy use of the  REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        theArgsParser.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theRoot.toSchema());
        }
    }

    @Test
    public void testXorEdgeCase1() throws ArgsSyntaxException {
        StringOption theTextArg = CliSugar.stringOption((String)"-t", (String)"--text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        Flag theEncryptFlag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given message.");
        ArgsSyntax theArgsSyntax = CliSugar.xor((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theEncryptFlag, theTextArg}), new AllCondition((Syntaxable)theEncryptFlag)});
        String[] args = new String[]{"-t", "text", "-e"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl(theArgsSyntax);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        Assertions.assertEquals((Object)"text", (Object)theTextArg.getValue());
    }

    @Test
    public void testXorEdgeCase2() throws ArgsSyntaxException {
        StringOption theTextArg = CliSugar.stringOption((String)"-t", (String)"--text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        Flag theEncryptFlag = CliSugar.flag((String)"-e", (String)"--encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given message.");
        ArgsSyntax theArgsSyntax = CliSugar.cases((Syntaxable[])new Syntaxable[]{CliSugar.and((Syntaxable[])new Syntaxable[]{theEncryptFlag, theTextArg}), theEncryptFlag});
        String[] args = new String[]{"-t", "text", "-e"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl(theArgsSyntax);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        Assertions.assertEquals((Object)"text", (Object)theTextArg.getValue());
    }

    @Test
    public void testArrayOption1() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        for (int i = 0; i < ((String[])theArray.getValue()).length; ++i) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption2() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption3() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3", "-t", "text4"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expected an <SuperfluousArgsException>!");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption4() throws ArgsSyntaxException {
        String[] args = new String[]{};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"), 1, 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption5() throws ArgsSyntaxException {
        String[] args = new String[]{};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)new AnyCondition(new Syntaxable[]{theArray}));
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        Assertions.assertFalse((boolean)theArray.hasValue());
        Assertions.assertNull((Object)theArray.getValue());
    }

    @Test
    public void testArrayOption6() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Option)theArray);
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        for (int i = 0; i < ((String[])theArray.getValue()).length; ++i) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption7() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption("-t", "--text", "text", "A text"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)new AnyCondition(new Syntaxable[]{theArray}));
        theArgsParser.withSyntaxNotation(SyntaxNotation.REFCODES);
        theArgsParser.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        for (int i = 0; i < ((String[])theArray.getValue()).length; ++i) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
        }
        Assertions.assertEquals((int)(args.length / 2), (int)((String[])theArray.getValue()).length);
    }

    @Test
    public void testOperation1() throws ArgsSyntaxException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        VerboseFlag verbose = new VerboseFlag();
        XorCondition theRoot = new XorCondition(new Syntaxable[]{new AndCondition(new Syntaxable[]{ls, verbose}), cd});
        String[] theArgs = new String[]{"ls", "--verbose"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theRoot);
        theArgsParser.evalArgs(theArgs);
        Assertions.assertTrue((boolean)ls.isEnabled());
        Assertions.assertTrue((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        theRoot.reset();
        theArgs = new String[]{"cd"};
        theArgsParser.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertTrue((boolean)cd.isEnabled());
    }

    @Test
    public void testNone1() throws ArgsSyntaxException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        NoneOperand none = new NoneOperand("none", "No arguments at all");
        VerboseFlag verbose = new VerboseFlag();
        XorCondition theRoot = new XorCondition(new Syntaxable[]{none, new AndCondition(new Syntaxable[]{ls, verbose}), cd});
        String[] theArgs = new String[]{"ls", "--verbose"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theRoot);
        theArgsParser.evalArgs(theArgs);
        Assertions.assertTrue((boolean)ls.isEnabled());
        Assertions.assertTrue((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        theRoot.reset();
        theArgs = new String[]{"cd"};
        theArgsParser.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertTrue((boolean)cd.isEnabled());
        Assertions.assertFalse((boolean)none.isEnabled());
    }

    @Test
    public void testNone2() throws ArgsSyntaxException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        NoneOperand none = new NoneOperand("none", "No arguments at all");
        VerboseFlag verbose = new VerboseFlag();
        XorCondition theRoot = new XorCondition(new Syntaxable[]{none, new AndCondition(new Syntaxable[]{ls, verbose}), cd});
        String[] theArgs = new String[]{};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((ArgsSyntax)theRoot);
        theArgsParser.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        Assertions.assertTrue((boolean)none.isEnabled());
    }

    private void testArgs(int i) throws ArgsSyntaxException {
        ArgsParserImpl theArgsParser = new ArgsParserImpl();
        HashMap<String, CallSite> theProperties = new HashMap<String, CallSite>();
        List theOperands = theArgsParser.evalArgs(ARGS[i]);
        for (Operand eOperand : theOperands) {
            theProperties.put(eOperand.getAlias(), (CallSite)((Object)("" + eOperand.getValue())));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Line <" + i + ">:");
        }
        for (String eKey : theProperties.keySet()) {
            if (!IS_LOG_TEST_ENABLED) continue;
            System.out.println(eKey + " := " + (String)theProperties.get(eKey));
        }
        String[] theExcepcted = PROPERTIES[i];
        for (int j = 0; j < theExcepcted.length; ++j) {
            PropertyImpl eProperty = new PropertyImpl(theExcepcted[j]);
            if (((String)eProperty.getKey()).equals("null")) {
                eProperty = new PropertyImpl(null, (String)eProperty.getValue());
            }
            Assertions.assertEquals((Object)eProperty.getValue(), theProperties.get(eProperty.getKey()), (String)("Line <" + i + "> (" + eProperty.toString() + ")"));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ArgsParser aArgsParser, String[] aArgs) {
        ArgsSyntax theArgsSyntax = aArgsParser.getArgsSyntax();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        aArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX).printHelp();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("[" + SyntaxNotation.REFCODES + " SYNTAX NOTATION]  " + theArgsSyntax.toSynopsis(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("[" + SyntaxNotation.GNU_POSIX + " SYNTAX NOTATION] " + theArgsSyntax.toSynopsis(SyntaxNotation.GNU_POSIX));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("[COMMAND LINE ARGS]         " + new VerboseTextBuilder().withElements((Object[])aArgs).toString());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("[INTERNAL STATUS]           " + theArgsSyntax.toString());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(List<? extends Operand<?>> aOperands) {
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(RuntimeUtility.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> eOperand : aOperands) {
            if (!IS_LOG_TEST_ENABLED) continue;
            System.out.println("[OPERAND] " + eOperand.toSyntax(SyntaxNotation.REFCODES));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    static enum BaseMetricsConfig {
        A,
        B,
        C;

    }

    static enum ChaosMode {
        X,
        Y,
        Z;

    }

    static enum SystemContext {
        S0,
        S1,
        S2;

    }

    static enum TrigonometricFunction {
        SINE,
        COSINE;

    }
}

