/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.data.CommandArgPrefixes;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.struct.Relation;

public abstract class AbstractOption<T>
extends AbstractOperand<T>
implements Option<T> {
    private static final String SHORT_OPTION = "SHORT_OPTION";
    private static final String LONG_OPTION = "LONG_OPTION";
    private String _shortOption;
    private String _longOption;

    public AbstractOption(String aShortOption, String aLongOption, Class<T> aType, String aAlias, String aDescription) {
        super(aType, aAlias, aDescription);
        if (aShortOption != null && (!aShortOption.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix()) || aShortOption.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix()))) {
            throw new IllegalArgumentException("Your short-option \"" + aShortOption + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        if (aLongOption != null && !aLongOption.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + aLongOption + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._shortOption = aShortOption;
        this._longOption = aLongOption;
    }

    protected AbstractOption(String aShortOption, String aLongOption, Class<T> aType, String aDescription) {
        super(aType, null, aDescription);
        if (aShortOption == null && aLongOption == null) {
            throw new IllegalArgumentException("You must provide at least a short-option or a long-option!");
        }
        if (!aShortOption.startsWith(CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix()) || aShortOption.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your short-option \"" + aShortOption + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        if (!aLongOption.startsWith(CommandArgPrefix.POSIX_LONG_OPTION.getPrefix())) {
            throw new IllegalArgumentException("Your long-option \"" + aLongOption + "\" must start exactly with \"" + CommandArgPrefix.POSIX_SHORT_OPTION.getPrefix() + "\".");
        }
        this._shortOption = aShortOption;
        this._longOption = aLongOption;
    }

    public AbstractOption(Relation<String, T> aProperty, Class<T> aType) {
        super(aProperty, aType);
    }

    @Override
    public List<Operand<T>> parseArgs(String[] aArgs, String[] aOptions) throws ArgsSyntaxException {
        Relation<String, String> theOptionArgument = CliUtility.getOptionArgument(this, aArgs, aOptions);
        if (theOptionArgument != null) {
            ArrayList<Operand<T>> theList = new ArrayList<Operand<T>>();
            theList.add(this);
            this.setArgs(new String[]{(String)theOptionArgument.getKey(), (String)theOptionArgument.getValue()});
            this.setValue(this.toType((String)theOptionArgument.getValue()));
            return theList;
        }
        if (CliUtility.contains(aArgs, this.getShortOption())) {
            throw new ParseArgsException(aArgs, "Missing value; the short-option \"" + this.getShortOption() + "\" requires a value.");
        }
        if (CliUtility.contains(aArgs, this.getLongOption())) {
            throw new ParseArgsException(aArgs, "Missing value; the long-option \"" + this.getLongOption() + "\" requires a value.");
        }
        throw new UnknownArgsException(aArgs, "Neither the short-option \"" + this.getShortOption() + "\" nor the long-option \"" + this.getLongOption() + "\"  was found in the command line arguments, at least one of them must be specified.");
    }

    @Override
    public String getShortOption() {
        return this._shortOption;
    }

    @Override
    public String getLongOption() {
        return this._longOption;
    }

    @Override
    public String toSyntax(SyntaxNotation aSyntaxNotation, String aOptEscCode, String aParamEscCode, String aResetEscCode) {
        aOptEscCode = aOptEscCode == null ? "" : aOptEscCode;
        aParamEscCode = aParamEscCode == null ? "" : aParamEscCode;
        aResetEscCode = aResetEscCode == null ? "" : aResetEscCode;
        return aOptEscCode + (this.getShortOption() != null ? this.getShortOption() : this.getLongOption()) + aResetEscCode + (String)(this.getAlias() != null ? " " + CliUtility.toParameterSpec(this, aParamEscCode, aResetEscCode) : "") + aResetEscCode;
    }

    @Override
    public String toState() {
        String theSwitch = null;
        if (this.getShortOption() != null) {
            theSwitch = this.getShortOption();
        } else if (this.getLongOption() != null) {
            theSwitch = this.getLongOption();
        }
        if (theSwitch != null) {
            StringBuilder theBuilder = new StringBuilder();
            theBuilder.append(theSwitch);
            theBuilder.append(":=");
            if (this.getValue() != null) {
                if (this.getValue() instanceof String) {
                    theBuilder.append('\"');
                }
                theBuilder.append(this.getValue().toString());
                if (this.getValue() instanceof String) {
                    theBuilder.append('\"');
                }
            } else {
                theBuilder.append("null");
            }
            return theBuilder.toString();
        }
        return "null";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = super.toSchema();
        theSchema.put(SHORT_OPTION, this._shortOption);
        theSchema.put(LONG_OPTION, this._longOption);
        return theSchema;
    }

    protected String[] getOptionPrefixes() {
        OperatingSystem theOperatingSystem = OperatingSystem.toOperatingSystem();
        if (theOperatingSystem == OperatingSystem.MAC) {
            return CommandArgPrefixes.POSIX.toPrefixes();
        }
        if (theOperatingSystem == OperatingSystem.UNIX) {
            return CommandArgPrefixes.POSIX.toPrefixes();
        }
        if (theOperatingSystem == OperatingSystem.WINDOWS) {
            return CommandArgPrefixes.WINDOWS.toPrefixes();
        }
        return CommandArgPrefix.toPrefixes();
    }

    @Override
    protected void setValue(T aValue) {
        super.setValue(aValue);
    }

    @Override
    protected void setArgs(String[] aArgs) {
        super.setArgs(aArgs);
    }
}

