/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsParserImpl;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class OptionalConditionTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testOptionalEdgeCase() {
        IntOption theWidth = CliSugar.intOption((Character)Character.valueOf('w'), (String)"width", (String)"width", (String)"Sets the console width");
        IntOption thePortOption = CliSugar.intOption((Character)Character.valueOf('p'), (String)"port", (String)"port", (String)"Sets the port for the server");
        IntOption theMaxConns = CliSugar.intOption((Character)Character.valueOf('c'), (String)"connections", (String)"connections", (String)"Sets the number of max. connections");
        StringOption theUsername = CliSugar.stringOption((Character)Character.valueOf('u'), (String)"user", (String)"username", (String)"The username for HTTP Basic-Authentication");
        StringOption theSecret = CliSugar.stringOption((Character)Character.valueOf('s'), (String)"secret", (String)"secret", (String)"The password for HTTP Basic-Authentication");
        Flag theSysInfo = CliSugar.flag(null, (String)"sysinfo", (String)"sysInfo", (String)"Shows some system information");
        IntOption theMgmPortOption = CliSugar.intOption((Character)Character.valueOf('m'), (String)"management-port", (String)"management-port", (String)"The management-port on which to listen for shutdown...");
        HelpFlag theHelp = CliSugar.helpFlag((String)"Shows this help");
        Condition theRoot = CliSugar.any((Constituent[])new Constituent[]{CliSugar.xor((Constituent[])new Constituent[]{CliSugar.any((Constituent[])new Constituent[]{thePortOption, theMaxConns, CliSugar.and((Constituent[])new Constituent[]{theUsername, theSecret}), theWidth, theMgmPortOption}), CliSugar.any((Constituent[])new Constituent[]{CliSugar.xor((Constituent[])new Constituent[]{theHelp, theSysInfo})})})});
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Constituent)theRoot);
        theArgsParser.withSyntaxMetrics((SyntaxMetrics)SyntaxNotation.LOGICAL);
        theArgsParser.withName("TinyRestful").withTitle("TINYRESTFUL").withCopyrightNote("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicenseNote("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        theArgsParser.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        theArgsParser.withDescription("Tiny evil RESTful server. TinyRestfulServer makes heavy use of the LOGICAL.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        String[] args = new String[]{"-p", "8080", "--sysinfo"};
        try {
            theArgsParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(new VerboseTextBuilder().withElements((Object[])e.toParsedArgs()).toString());
            }
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.getMessage());
            }
            Assertions.assertEquals((int)3, (int)e.toParsedArgs().length);
        }
    }
}

