/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractConstituent;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.ArgsPrefix;
import org.refcodes.struct.Relation;
import org.refcodes.textual.VerboseTextBuilder;

public abstract class AbstractOperand<T>
extends AbstractConstituent
implements Operand<T> {
    private Class<T> _type;
    private String _alias;
    private String[] _args = null;
    protected T _value = null;

    public AbstractOperand(Class<T> aType, String aAlias, String aDescription) {
        super(aDescription);
        this._type = aType;
        this._alias = aAlias;
    }

    public AbstractOperand(Relation<String, T> aProperty, Class<T> aType) {
        this._alias = (String)aProperty.getKey();
        this._value = aProperty.getValue();
        this._type = aType;
    }

    public List<Operand<T>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliContext) throws ArgsSyntaxException {
        int first = -1;
        int i = aArgs.length - 1;
        while (i >= 0) {
            if (!(aCliContext.isOption(aArgs[i]) || first != -1 && first + -1 != i)) {
                first = i;
            }
            --i;
        }
        if (first != -1) {
            ArrayList<Operand<T>> theList = new ArrayList<Operand<T>>();
            theList.add(this);
            this.setValue(this.toType(aArgs[first]));
            this.setParsedArgs(new String[]{aArgs[first]});
            return theList;
        }
        throw new UnknownArgsException(aArgs, "Unable to parse any args (not being prefixed with " + new VerboseTextBuilder().withElements((Object[])ArgsPrefix.toPrefixes()).toString() + ").");
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toArgumentSpec(this);
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public T getValue() {
        return this._value;
    }

    @Override
    public String[] toParsedArgs() {
        return this._args;
    }

    public void reset() {
        this._args = null;
        this._value = null;
    }

    public String toString() {
        return this.toSchema().toString();
    }

    @Override
    public int compareTo(Operand<?> obj) {
        if (obj instanceof Option var2_3) {
            if (this instanceof Option var5_5) {
                String otherOption = aOption.getShortOption() != null ? aOption.getShortOption().toString() : aOption.getLongOption();
                String thisOption = theOption.getShortOption() != null ? theOption.getShortOption().toString() : theOption.getLongOption();
                return thisOption.compareTo(otherOption);
            }
            if (this instanceof Operand) {
                return 1;
            }
        }
        if (obj instanceof Operand && this instanceof Option) {
            return -11;
        }
        if (this.getAlias() != null && obj.getAlias() != null) {
            return this.getAlias().compareTo(obj.getAlias());
        }
        return this.toSyntax().compareTo(obj.toSyntax());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public CliSchema toSchema() {
        return new CliSchema(this.getClass(), this._alias, this._description, this._value);
    }

    protected void setValue(T aValue) {
        this._value = aValue;
    }

    protected void setParsedArgs(String[] aArgs) {
        this._args = aArgs;
    }

    protected abstract T toType(String var1) throws ParseArgsException;
}

