/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.cli.AbstractOperand;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public abstract class AbstractOption<T>
extends AbstractOperand<T>
implements Option<T> {
    private static final String SHORT_OPTION_KEY = "SHORT_OPTION";
    private static final String LONG_OPTION_KEY = "LONG_OPTION";
    private Character _shortOption;
    private String _longOption;

    public AbstractOption(String aLongOption, Class<T> aType, String aDescription) {
        this(null, aLongOption, aType, null, aDescription);
    }

    public AbstractOption(String aLongOption, Class<T> aType, String aAlias, String aDescription) {
        this(null, aLongOption, aType, aAlias, aDescription);
    }

    protected AbstractOption(Character aShortOption, String aLongOption, Class<T> aType, String aDescription) {
        this(aShortOption, aLongOption, aType, null, aDescription);
    }

    public AbstractOption(Character aShortOption, String aLongOption, Class<T> aType, String aAlias, String aDescription) {
        super(aType, aAlias != null ? aAlias : (aLongOption != null ? aLongOption : (aShortOption != null ? aShortOption.toString() : null)), aDescription);
        if (aShortOption == null && (aLongOption == null || aLongOption.length() == 0)) {
            throw new IllegalArgumentException("At least the short option <" + (aShortOption != null ? "'" + aShortOption + "'" : aShortOption) + "> must not be null or the long option <" + (aLongOption != null ? "\"" + aLongOption + "\"" : aLongOption) + "> must not be empty!");
        }
        this._shortOption = aShortOption;
        this._longOption = aLongOption;
    }

    public AbstractOption(Relation<String, T> aProperty, Class<T> aType) {
        super(aProperty, aType);
        this._shortOption = ((String)aProperty.getKey()).length() == 1 ? Character.valueOf(((String)aProperty.getKey()).charAt(0)) : null;
        this._longOption = ((String)aProperty.getKey()).length() > 1 ? (String)aProperty.getKey() : null;
    }

    @Override
    public List<Operand<T>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        Relation<String, String> theOptionArgument = AbstractOption.toOptionArgument(this, aArgs, aOptions, aCliCtx);
        if (theOptionArgument != null) {
            ArrayList<Operand<T>> theList = new ArrayList<Operand<T>>();
            theList.add(this);
            this.setParsedArgs(new String[]{(String)theOptionArgument.getKey(), (String)theOptionArgument.getValue()});
            this.setValue(this.toType((String)theOptionArgument.getValue()));
            return theList;
        }
        if (AbstractOption.contains(aArgs, aCliCtx.toShortOption(this))) {
            throw new ParseArgsException(aArgs, "Missing value; the short-option \"" + aCliCtx.toShortOption(this) + "\" requires a value.");
        }
        if (AbstractOption.contains(aArgs, aCliCtx.toLongOption(this))) {
            throw new ParseArgsException(aArgs, "Missing value; the long-option \"" + aCliCtx.toLongOption(this) + "\" requires a value.");
        }
        throw new UnknownArgsException(aArgs, "Neither the short-option \"" + aCliCtx.toShortOption(this) + "\" nor the long-option \"" + aCliCtx.toLongOption(this) + "\"  was found in the command line arguments, at least one of them must be specified.");
    }

    @Override
    public Character getShortOption() {
        return this._shortOption;
    }

    @Override
    public String getLongOption() {
        return this._longOption;
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return String.valueOf(aCliCtx.toOptionEscapeCode()) + aCliCtx.toOption(this) + aCliCtx.toResetEscapeCode() + (this.getAlias() != null ? " " + aCliCtx.toArgumentSpec(this) : "") + aCliCtx.toResetEscapeCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = super.toSchema();
        theSchema.put(SHORT_OPTION_KEY, this._shortOption);
        theSchema.put(LONG_OPTION_KEY, this._longOption);
        return theSchema;
    }

    @Override
    protected void setValue(T aValue) {
        super.setValue(aValue);
    }

    @Override
    protected void setParsedArgs(String[] aArgs) {
        super.setParsedArgs(aArgs);
    }

    protected static boolean contains(String[] aArgs, String aArg) {
        ArrayList<String> theList = new ArrayList<String>(Arrays.asList(aArgs));
        return theList.contains(aArg);
    }

    protected static Relation<String, String> toOptionArgument(Option<?> aOption, String[] aArgs, String[] aOptions, CliContext aCliCtx) {
        if (aArgs.length < 2) {
            return null;
        }
        Relation<String, String> theAttribute = AbstractOption.toOptionArgument(aArgs, aCliCtx.toShortOption(aOption), aOptions);
        if (theAttribute != null) {
            return theAttribute;
        }
        theAttribute = AbstractOption.toOptionArgument(aArgs, aCliCtx.toLongOption(aOption), aOptions);
        if (theAttribute != null) {
            return theAttribute;
        }
        return null;
    }

    protected static Relation<String, String> toOptionArgument(String[] aArgs, String aOption, String[] aOptions) {
        int i = 0;
        while (i < aArgs.length - 1) {
            String eArg = aArgs[i];
            if (eArg.equals(aOption)) {
                String eOptArg = aArgs[i + 1];
                String[] stringArray = aOptions;
                int n = aOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    String eOption = stringArray[n2];
                    if (eOptArg.equalsIgnoreCase(eOption)) {
                        return null;
                    }
                    ++n2;
                }
                return new RelationImpl((Object)aOption, (Object)eOptArg);
            }
            ++i;
        }
        return null;
    }
}

