/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.refcodes.cli.ArgumentEscapeCodeAccessor;
import org.refcodes.cli.ArrayOperand;
import org.refcodes.cli.CliMetrics;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Flag;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.OptionEscapeCodeAccessor;
import org.refcodes.cli.Optionable;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxMetricsAccessor;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.runtime.Terminal;

public class CliContext
implements CliMetrics,
Optionable {
    private SyntaxMetrics _syntaxMetrics = SyntaxNotation.LOGICAL;
    private String _argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
    private String _optionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
    private String _resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private boolean _isEscapeCodesEnabled = Terminal.isAnsiTerminalPreferred();

    private CliContext(Builder builder) {
        this._syntaxMetrics = builder.syntaxMetrics;
        this._argumentEscapeCode = builder.argumentEscapeCode;
        this._optionEscapeCode = builder.optionEscapeCode;
        this._resetEscapeCode = builder.resetEscapeCode;
        this._isEscapeCodesEnabled = builder.isEscapeCodesEnabled;
    }

    public CliContext() {
    }

    public CliContext(boolean isEscapeCodesEnabled) {
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, boolean isEscapeCodesEnabled) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    public CliContext(String aArgumentEscapeCode, String aOptionEscapeCode, String aResetEscapeCode) {
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._optionEscapeCode = aOptionEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    public CliContext(CliMetrics aCliMetrics) {
        this._syntaxMetrics = aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = aCliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._optionEscapeCode = aCliMetrics.getOptionEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(CliMetrics aCliMetrics, SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics != null ? aSyntaxMetrics : aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = aCliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._optionEscapeCode = aCliMetrics.getOptionEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, String aArgumentEscapeCode, String aOptionEscapeCode, String aResetEscapeCode) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._optionEscapeCode = aOptionEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, Character aShortOptionPrefix, String aLongOptionPrefix, boolean isEscapeCodesEnabled, String aArgumentEscapeCode, String aOptionEscapeCode, String aResetEscapeCode) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._optionEscapeCode = aOptionEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    @Override
    public String getOptionEscapeCode() {
        return this._optionEscapeCode;
    }

    @Override
    public String getArgumentEscapeCode() {
        return this._argumentEscapeCode;
    }

    public String getResetEscapeCode() {
        return this._resetEscapeCode;
    }

    @Override
    public SyntaxMetrics getSyntaxMetrics() {
        return this._syntaxMetrics;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    public boolean isOption(String aArg) {
        if (aArg != null && aArg.length() != 0) {
            if (this._syntaxMetrics.getLongOptionPrefix() != null && aArg.startsWith(this._syntaxMetrics.getLongOptionPrefix())) {
                return true;
            }
            if (this._syntaxMetrics.getShortOptionPrefix() != null && this._syntaxMetrics.getShortOptionPrefix().equals(Character.valueOf(aArg.charAt(0)))) {
                return true;
            }
        }
        return false;
    }

    public String[] toAllOptions(Constituent aConstituent) {
        HashSet<String> theOptions = new HashSet<String>();
        if (aConstituent instanceof Condition var4_4) {
            for (Operand<?> operand : theCondition.toOperands()) {
                String[] eOptions = this.toAllOptions(operand);
                if (eOptions == null || eOptions.length == 0) continue;
                theOptions.addAll(Arrays.asList(eOptions));
            }
        }
        if (aConstituent instanceof Option var7_8) {
            String theShortOption = this.toShortOption(var7_8);
            String theLongOption = this.toLongOption(var7_8);
            if (theShortOption != null) {
                theOptions.add(theShortOption);
            }
            if (theLongOption != null) {
                theOptions.add(theLongOption);
            }
        }
        return theOptions.toArray(new String[theOptions.size()]);
    }

    public String toLongOption(Option<?> aOption) {
        return aOption != null && aOption.getLongOption() != null ? String.valueOf(this._syntaxMetrics.getLongOptionPrefix()) + aOption.getLongOption() : null;
    }

    public String toOption(Option<?> aOption) {
        String theOption = this.toShortOption(aOption);
        return theOption != null ? theOption : this.toLongOption(aOption);
    }

    public String toOptionEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._optionEscapeCode != null ? this._optionEscapeCode : "") : "";
    }

    @Override
    public String[] toOptions(Option<?> aOption) {
        return CliContext.toOptions(aOption, this._syntaxMetrics.getShortOptionPrefix(), this._syntaxMetrics.getLongOptionPrefix());
    }

    public String toArgumentEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._argumentEscapeCode != null ? this._argumentEscapeCode : "") : "";
    }

    public String toArgumentSpec(Operand<?> aOperand) {
        if (aOperand instanceof ArrayOperand) {
            ArrayOperand theArrayOperand = (ArrayOperand)aOperand;
            return this.toArgumentSpec(aOperand, theArrayOperand.getMinLength(), theArrayOperand.getMaxLength());
        }
        return this.toArgumentSpec(aOperand, -1, -1);
    }

    public String toArgumentSpec(Operand<?> aOperand, int aMin, int aMax) {
        if (aOperand.getAlias() == null) {
            return "";
        }
        StringBuilder theBuilder = new StringBuilder();
        if (!(aOperand instanceof Flag) && aOperand.getAlias() != null) {
            if (aOperand instanceof Option) {
                theBuilder.append(this.getSyntaxMetrics().getArgumentPrefix());
            }
            theBuilder.append(String.valueOf(aOperand instanceof NoneOperand ? aOperand.toSyntax(this) : String.valueOf(this.toArgumentEscapeCode()) + aOperand.getAlias()) + this.toResetEscapeCode());
            if (aOperand.getType().isArray()) {
                theBuilder.append(this._syntaxMetrics.getBeginArraySymbol());
            } else if (aMin != -1 || aMax != -1) {
                theBuilder.append(this._syntaxMetrics.getBeginRangeSymbol());
            }
            if (aMin != -1 && aMin == aMax) {
                theBuilder.append(aMin);
            } else {
                if (aMin != -1) {
                    theBuilder.append(aMin);
                }
                if (aOperand.getType().isArray() || aMin != -1 || aMax != -1) {
                    theBuilder.append(this._syntaxMetrics.getIntervalSymbol());
                }
                if (aMax != -1) {
                    theBuilder.append(aMax);
                }
            }
            if (aOperand.getType().isArray()) {
                theBuilder.append(this._syntaxMetrics.getEndArraySymbol());
            } else if (aMin != -1 || aMax != -1) {
                theBuilder.append(this._syntaxMetrics.getEndRangeSymbol());
            }
            if (aOperand instanceof Option) {
                theBuilder.append(this._syntaxMetrics.getArgumentSuffix());
            }
        }
        return theBuilder.toString();
    }

    public String toResetEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._resetEscapeCode != null ? this._resetEscapeCode : "") : "";
    }

    public String toShortOption(Option<?> aOption) {
        return aOption != null && aOption.getShortOption() != null ? String.valueOf(this._syntaxMetrics.getShortOptionPrefix().toString()) + aOption.getShortOption() : null;
    }

    public String toSpec(Operand<?> aOperand) {
        StringBuilder theBuilder = new StringBuilder();
        if (aOperand instanceof Option var3_4) {
            theBuilder.append(String.valueOf(this.toOptionEscapeCode()) + this.toOption((Option<?>)theOption) + this.toResetEscapeCode());
        }
        if ((theArgumentSpec = this.toArgumentSpec(aOperand)) != null && theArgumentSpec.length() != 0 && theBuilder.length() > 0) {
            theBuilder.append(' ');
        }
        theBuilder.append(theArgumentSpec);
        return theBuilder.toString();
    }

    static String[] toOptions(Option<?> aOption, Character aShortOptionPrefix, String aLongOptionPrefix) {
        String theLongOption;
        String theShortOption;
        int i = 0;
        String string = aOption != null && aOption.getShortOption() != null ? String.valueOf(aShortOptionPrefix != null ? aShortOptionPrefix.toString() : "") + aOption.getShortOption() : (theShortOption = null);
        String string2 = aOption != null && aOption.getLongOption() != null ? String.valueOf(aLongOptionPrefix != null ? aLongOptionPrefix : "") + aOption.getLongOption() : (theLongOption = null);
        if (theShortOption != null) {
            ++i;
        }
        if (theLongOption != null) {
            ++i;
        }
        String[] theResult = new String[i];
        i = 0;
        if (theShortOption != null) {
            theResult[i] = theShortOption;
            ++i;
        }
        if (theLongOption != null) {
            theResult[i] = theLongOption;
        }
        return theResult;
    }

    public String[] toExpandOptions(String[] aArgs) {
        ArrayList<String> theArgs = new ArrayList<String>();
        if (this.getSyntaxMetrics().getShortOptionPrefix() != null) {
            String[] stringArray = aArgs;
            int n = aArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String eArg = stringArray[n2];
                if (!(eArg.length() <= 2 || this.getSyntaxMetrics().getLongOptionPrefix() != null && this.getSyntaxMetrics().getLongOptionPrefix().length() != 0 && eArg.startsWith(this.getSyntaxMetrics().getLongOptionPrefix()) || eArg.charAt(0) != this.getSyntaxMetrics().getShortOptionPrefix().charValue())) {
                    int i = 1;
                    while (i < eArg.length()) {
                        theArgs.add(String.valueOf(this.getSyntaxMetrics().getShortOptionPrefix().toString()) + eArg.charAt(i));
                        ++i;
                    }
                } else {
                    theArgs.add(eArg);
                }
                ++n2;
            }
        }
        return theArgs.toArray(new String[theArgs.size()]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SyntaxMetricsAccessor.SyntaxMetricsBuilder<Builder>,
    ArgumentEscapeCodeAccessor.ArgumentEscapeCodeBuilder<Builder>,
    OptionEscapeCodeAccessor.OptionEscapeCodeBuilder<Builder>,
    ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<Builder>,
    EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<Builder> {
        private SyntaxMetrics syntaxMetrics = SyntaxNotation.LOGICAL;
        private String argumentEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC});
        private String optionEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD});
        private String resetEscapeCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
        private boolean isEscapeCodesEnabled = Terminal.isAnsiTerminalPreferred();

        private Builder() {
        }

        @Override
        public Builder withSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
            this.syntaxMetrics = aSyntaxMetrics;
            return this;
        }

        @Override
        public Builder withArgumentEscapeCode(String aArgumentEscapeCode) {
            this.argumentEscapeCode = aArgumentEscapeCode;
            return this;
        }

        @Override
        public Builder withOptionEscapeCode(String aOptionEscapeCode) {
            this.optionEscapeCode = aOptionEscapeCode;
            return this;
        }

        public Builder withResetEscapeCode(String aResetEscapeCode) {
            this.resetEscapeCode = aResetEscapeCode;
            return this;
        }

        public Builder withEscapeCodesEnabled(boolean isEscapeCodesEnabled) {
            this.isEscapeCodesEnabled = isEscapeCodesEnabled;
            return this;
        }

        public CliContext build() {
            return new CliContext(this);
        }
    }
}

