/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Option;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.textual.VerboseTextBuilder;

public class XorCondition
extends AbstractCondition
implements Condition {
    public XorCondition(Constituent ... aArgs) {
        super("Exactly one (XOR) of the nested syntaxables must match from the arguments.", aArgs);
    }

    protected XorCondition(String aDescription, Constituent ... aArgs) {
        super(aDescription, aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList<Condition> theOptionals = new ArrayList<Condition>();
        List<Operand<?>> theResult = null;
        Constituent theResultSyntaxable = null;
        List<Operand<?>> eOperands = null;
        int theMatchCount = this.getChildren().size();
        for (Constituent eChild : this.getChildren()) {
            if (eChild instanceof AnyCondition) {
                theOptionals.add((AnyCondition)eChild);
            }
            try {
                eOperands = theResult != null && eChild instanceof Operand && theResultSyntaxable instanceof Option ? eChild.parseArgs(CliUtility.toArgsDiff(aArgs, theResult), aOptions, aCliCtx) : eChild.parseArgs(aArgs, aOptions, aCliCtx);
                if (eOperands != null && eOperands.isEmpty()) {
                    eOperands = null;
                }
            }
            catch (ArgsSyntaxException ignore) {
                --theMatchCount;
            }
            if ((theResult = XorCondition.removeDuplicates(theResult, eOperands)) != null && eOperands != null) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match: " + new VerboseTextBuilder().withElements((Object[])CliUtility.toParsedArgs(theResult, eOperands)).toString());
            }
            if (eOperands != null && !eOperands.isEmpty() && theResult == null) {
                theResult = eOperands;
                theResultSyntaxable = eChild;
            }
            eOperands = null;
        }
        if (theMatchCount == 0) {
            throw new UnknownArgsException(aArgs, "Not one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match!");
        }
        if (theMatchCount > 1) {
            if (theOptionals.size() > 1 && aArgs != null && aArgs.length > 0) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive optional syntax matched the provided command line arguments, causing exclusive contextual ambiguity: " + new VerboseTextBuilder().withElements(XorCondition.toSpec(theOptionals)).toString());
            }
            if ((theMatchCount -= theOptionals.size()) > 1) {
                throw new AmbiguousArgsException(aArgs, "More than one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match:");
            }
        }
        if (theResult != null) {
            return theResult;
        }
        if (theOptionals.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        throw new UnknownArgsException(aArgs, "Not one exclusive syntax matched the provided command line arguments, though exactly one exclusiveness must match!");
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        String theSynopsis = "";
        for (Constituent eChild : this.getChildren()) {
            if (theSynopsis.length() != 0) {
                theSynopsis = String.valueOf(theSynopsis) + (aCliCtx.getSyntaxMetrics().getXorSymbol() != null && aCliCtx.getSyntaxMetrics().getXorSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getXorSymbol() + " " : " ");
            }
            theSynopsis = String.valueOf(theSynopsis) + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }

    private static List<String> toSpec(List<Condition> aConditions) {
        ArrayList<String> theParameters = new ArrayList<String>();
        for (Condition eArgsSyntax : aConditions) {
            for (Operand<?> eOperand : eArgsSyntax.toOperands()) {
                theParameters.add(new CliContext(false).toSpec(eOperand));
            }
        }
        return theParameters;
    }

    private static List<Operand<?>> removeDuplicates(List<Operand<?>> aElements, List<Operand<?>> aDuplicates) {
        if (aElements != null && aDuplicates != null) {
            for (Operand<?> eOperand : aDuplicates) {
                if (!aElements.contains(eOperand)) continue;
                aElements.remove(eOperand);
            }
            if (aElements.isEmpty()) {
                aElements = null;
            }
        }
        return aElements;
    }
}

