/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.textual.VerboseTextBuilder;

public class AllCondition
extends AbstractCondition
implements Condition {
    public AllCondition(Constituent aArg) {
        super("All (ALL) arguments passed are to be consumed by the nested syntaxables.", aArg);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        List<? extends Operand<?>> theResult = this.getFirst().parseArgs(aArgs, aOptions, aCliCtx);
        String[] theRemainderArgs = CliUtility.toArgsDiff(aArgs, theResult);
        if (theRemainderArgs != null && theRemainderArgs.length != 0) {
            throw new SuperfluousArgsException(theRemainderArgs, "There were command line arguments (" + VerboseTextBuilder.asString((String[])theRemainderArgs) + ") ");
        }
        return theResult;
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            Object theSyntax = "";
            for (Constituent eChild : this.getChildren()) {
                if (((String)theSyntax).length() != 0) {
                    theSyntax = (String)theSyntax + " ";
                }
                if (aCliCtx.getSyntaxMetrics().getAllSymbol() != null && aCliCtx.getSyntaxMetrics().getAllSymbol().length() != 0) {
                    theSyntax = (String)theSyntax + aCliCtx.getSyntaxMetrics().getAllSymbol() + aCliCtx.getSyntaxMetrics().getBeginListSymbol() + " ";
                }
                theSyntax = (String)theSyntax + eChild.toSyntax(aCliCtx);
                if (aCliCtx.getSyntaxMetrics().getAllSymbol() == null || aCliCtx.getSyntaxMetrics().getAllSymbol().length() == 0) continue;
                theSyntax = (String)theSyntax + " " + aCliCtx.getSyntaxMetrics().getEndListSymbol();
            }
            return theSyntax;
        }
        return "";
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            if (this.getChildren().size() == 1) {
                return this.getChildren().get(0).toSynopsis(aCliCtx);
            }
            Object theSynopsis = "";
            for (Constituent eChild : this.getChildren()) {
                if (((String)theSynopsis).length() != 0) {
                    theSynopsis = (String)theSynopsis + " ";
                }
                theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
            }
            return theSynopsis;
        }
        return "";
    }

    @Override
    public void reset() {
        this.getChildren().get(0).reset();
    }

    @Override
    public String toString() {
        return this.toSchema().toString();
    }
}

