/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.data.ArgsPrefix;

public enum SyntaxNotation implements SyntaxMetrics
{
    LOGICAL(Character.valueOf(ArgsPrefix.POSIX_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.POSIX_LONG_OPTION.getPrefix(), "<", ">", "(", ")", "[", "]", "[", "]", "{", "}", "\u2026", "\u2205", "\u2200", "?", "&", "|", "^"),
    GNU_POSIX(Character.valueOf(ArgsPrefix.POSIX_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.POSIX_LONG_OPTION.getPrefix(), "<", ">", "{", "}", "[", "]", "[", "]", "{", "}", "...", "{}", null, null, null, "?", "|"),
    WINDOWS(Character.valueOf(ArgsPrefix.WINDOWS_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.WINDOWS_LONG_OPTION.getPrefix(), "$", "", "{", "}", "[", "]", "[", "]", "{", "}", "...", "{}", null, null, null, "?", "|"),
    VERBOSE(Character.valueOf(ArgsPrefix.POSIX_SHORT_OPTION.getPrefix().charAt(0)), ArgsPrefix.POSIX_LONG_OPTION.getPrefix(), "<", ">", "{", "}", "{", "}", "[", "]", "{", "}", "-", "EMPTY", "ALL", "ANY", "AND", "OR", "XOR");

    public static final SyntaxNotation DEFAULT;
    private String _argumentPrefix;
    private String _argumentSuffix;
    private Character _shortOptionPrefix;
    private String _longOptionPrefix;
    private String _beginListSymbol;
    private String _endListSymbol;
    private String _xorSymString;
    private String _allSymString;
    private String _beginArraySymbol;
    private String _endArraySymbol;
    private String _beginRangeSymbol;
    private String _endRangeSymbol;
    private String _intervalSymbol;
    private String _andSymbol;
    private String _emptySymbol;
    private String _anySymbol;
    private String _orSymbol;
    private String _beginOptionalSymbol;
    private String _endOptionalSymbol;

    private SyntaxNotation(Character aShortOptionPrefix, String aLongOptionPrefix, String aArgumentPrefix, String aArgumentSuffix, String aBeginListSymbol, String aEndListSymbol, String aBeginArraySymbol, String aEndArraySymbol, String aBeginOptionalSymbol, String aEndOptionalSymbol, String aBeginRangeSymbol, String aEndRangeSymbol, String aIntervalSymbol, String aEmptySymbol, String aAllSymbol, String aAnySymbol, String aAndSymbol, String aOrSymbol, String aXorSymbol) {
        this._argumentPrefix = aArgumentPrefix;
        this._argumentSuffix = aArgumentSuffix;
        this._shortOptionPrefix = aShortOptionPrefix;
        this._longOptionPrefix = aLongOptionPrefix;
        this._beginListSymbol = aBeginListSymbol;
        this._endListSymbol = aEndListSymbol;
        this._xorSymString = aXorSymbol;
        this._orSymbol = aOrSymbol;
        this._allSymString = aAllSymbol;
        this._andSymbol = aAndSymbol;
        this._anySymbol = aAnySymbol;
        this._beginOptionalSymbol = aBeginOptionalSymbol;
        this._endOptionalSymbol = aEndOptionalSymbol;
        this._intervalSymbol = aIntervalSymbol;
        this._beginRangeSymbol = aBeginRangeSymbol;
        this._endRangeSymbol = aEndRangeSymbol;
        this._beginArraySymbol = aBeginArraySymbol;
        this._endArraySymbol = aEndArraySymbol;
        this._emptySymbol = aEmptySymbol;
    }

    @Override
    public String getArgumentPrefix() {
        return this._argumentPrefix;
    }

    @Override
    public String getArgumentSuffix() {
        return this._argumentSuffix;
    }

    @Override
    public Character getShortOptionPrefix() {
        return this._shortOptionPrefix;
    }

    @Override
    public String getLongOptionPrefix() {
        return this._longOptionPrefix;
    }

    @Override
    public String getBeginListSymbol() {
        return this._beginListSymbol;
    }

    @Override
    public String getEndListSymbol() {
        return this._endListSymbol;
    }

    @Override
    public String getBeginArraySymbol() {
        return this._beginArraySymbol;
    }

    @Override
    public String getBeginRangeSymbol() {
        return this._beginRangeSymbol;
    }

    @Override
    public String getEndArraySymbol() {
        return this._endArraySymbol;
    }

    @Override
    public String getEndRangeSymbol() {
        return this._endRangeSymbol;
    }

    @Override
    public String getIntervalSymbol() {
        return this._intervalSymbol;
    }

    @Override
    public String getXorSymbol() {
        return this._xorSymString;
    }

    @Override
    public String getOrSymbol() {
        return this._orSymbol;
    }

    @Override
    public String getAndSymbol() {
        return this._andSymbol;
    }

    @Override
    public String getEmptySymbol() {
        return this._emptySymbol;
    }

    @Override
    public String getAllSymbol() {
        return this._allSymString;
    }

    @Override
    public String getBeginOptionalSymbol() {
        return this._beginOptionalSymbol;
    }

    @Override
    public String getEndOptionalSymbol() {
        return this._endOptionalSymbol;
    }

    @Override
    public String getAnySymbol() {
        return this._anySymbol;
    }

    public static SyntaxNotation toSyntaxNotation(String aValue) {
        aValue = aValue != null ? aValue.replaceAll("-", "").replaceAll("_", "") : aValue;
        for (SyntaxNotation eValue : SyntaxNotation.values()) {
            if (!eValue.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(aValue)) continue;
            return eValue;
        }
        return null;
    }

    static {
        DEFAULT = GNU_POSIX;
    }
}

