// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import org.refcodes.cli.CliException.ConsoleArgsException;

/**
 * Thrown in case of a command line arguments mismatch regarding provided and
 * expected args.
 */
public class ArgsSyntaxException extends ConsoleArgsException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new args mismatch exception.
	 *
	 * @param aArgs the args
	 * @param aMessage The aMessage describing this exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public ArgsSyntaxException( String[] aArgs, String aMessage, String aErrorCode ) {
		super( aArgs, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new args mismatch exception.
	 *
	 * @param aArgs the args
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public ArgsSyntaxException( String[] aArgs, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aArgs, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new args mismatch exception.
	 *
	 * @param aArgs the args
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public ArgsSyntaxException( String[] aArgs, String aMessage, Throwable aCause ) {
		super( aArgs, aMessage, aCause );
	}

	/**
	 * Instantiates a new args mismatch exception.
	 *
	 * @param aArgs the args
	 * @param aMessage The aMessage describing this exception.
	 */
	public ArgsSyntaxException( String[] aArgs, String aMessage ) {
		super( aArgs, aMessage );
	}

	/**
	 * Instantiates a new args mismatch exception.
	 *
	 * @param aArgs the args
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public ArgsSyntaxException( String[] aArgs, Throwable aCause, String aErrorCode ) {
		super( aArgs, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new args mismatch exception.
	 *
	 * @param aArgs the args
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public ArgsSyntaxException( String[] aArgs, Throwable aCause ) {
		super( aArgs, aCause );
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
