/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.cli.AbstractConstituent;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Synopsisable;

public abstract class AbstractCondition
extends AbstractConstituent
implements Condition {
    private List<Constituent> _children = new ArrayList<Constituent>();

    public AbstractCondition(String aDescription, Constituent ... aElements) {
        super(aDescription);
        this._children.addAll(Arrays.asList(aElements));
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        Object theSyntax = this.toSynopsis(aCliCtx);
        if (((String)theSyntax).length() > 0 && this.getChildren() != null && this.getChildren().size() > 1) {
            theSyntax = aCliCtx.getSyntaxMetrics().getBeginListSymbol() + " " + (String)theSyntax + " " + aCliCtx.getSyntaxMetrics().getEndListSymbol();
        }
        return ((String)theSyntax).toString();
    }

    public void reset() {
        for (Constituent eSyntaxable : this._children) {
            eSyntaxable.reset();
        }
    }

    public String toString() {
        return this.toSchema().toString();
    }

    @Override
    public CliSchema toSchema() {
        CliSchema[] theSchemas = null;
        if (this._children != null && this._children.size() != 0) {
            theSchemas = new CliSchema[this._children.size()];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = this._children.get(i).toSchema();
            }
        }
        return new CliSchema(this.getClass(), this._description, theSchemas);
    }

    public List<Operand<?>> toOperands() {
        ArrayList theList = new ArrayList();
        for (Synopsisable synopsisable : this.getChildren()) {
            if (synopsisable instanceof Operand) {
                theList.add((Operand)synopsisable);
            }
            if (!(synopsisable instanceof Condition)) continue;
            theList.addAll(((Condition)synopsisable).toOperands());
        }
        return theList;
    }

    protected List<Constituent> getChildren() {
        return this._children;
    }

    protected Constituent getFirst() {
        return this._children.get(0);
    }

    protected void addChild(Constituent aArgumentizer) {
        this._children.add(aArgumentizer);
    }

    @Override
    public <V> V toValue(String aAlias) {
        for (Constituent eElement : this._children) {
            Object eValue = eElement.toValue(aAlias);
            if (eValue == null) continue;
            return eValue;
        }
        return null;
    }

    @Override
    public <T extends Operand<?>> T toOperand(String aAlias, Class<T> aType) {
        for (Constituent eSyntaxable : this.getChildren()) {
            Condition eCondition;
            Operand eOperand;
            if (eSyntaxable instanceof Operand) {
                eOperand = (Operand)eSyntaxable;
                boolean eTypeMatch = true;
                boolean eAliasMatch = true;
                if (aAlias != null && aAlias.length() != 0) {
                    eAliasMatch = aAlias.equals(eOperand.getAlias());
                }
                if (aType != null) {
                    eTypeMatch = aType.isAssignableFrom(eOperand.getClass());
                }
                if (!eTypeMatch || !eAliasMatch) continue;
                return (T)eOperand;
            }
            if (!(eSyntaxable instanceof Condition) || (eOperand = (eCondition = (Condition)eSyntaxable).toOperand(aAlias, aType)) == null) continue;
            return (T)eOperand;
        }
        return null;
    }
}

