/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Operand;
import org.refcodes.cli.UnknownArgsException;

public class AndCondition
extends AbstractCondition
implements Condition {
    public AndCondition(Constituent ... aArgs) {
        super("All (AND) nested syntaxables must match from the arguments.", aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList theResult = new ArrayList();
        for (Constituent eChild : this.getChildren()) {
            List<Operand<?>> eOperands;
            try {
                eOperands = eChild.parseArgs(aArgs, aOptions, aCliCtx);
            }
            catch (UnknownArgsException exc) {
                throw new UnknownArgsException(exc.toParsedArgs(), "At least one mandatory syntax did not match the provided command line arguments, though all mandatories must match.", (Throwable)((Object)exc));
            }
            catch (AmbiguousArgsException exc) {
                throw new AmbiguousArgsException(exc.toParsedArgs(), "At least one mandatory syntax did not match the provided command line arguments, though all mandatories must match.", (Throwable)((Object)exc));
            }
            if (eOperands != null && eOperands.size() != 0) {
                theResult.addAll(eOperands);
            }
            aArgs = CliUtility.toArgsDiff(aArgs, eOperands);
        }
        return theResult;
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return this.toSynopsis(aCliCtx);
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        Object theSynopsis = "";
        for (Constituent eChild : this.getChildren()) {
            if (((String)theSynopsis).length() != 0) {
                theSynopsis = (String)theSynopsis + (String)(aCliCtx.getSyntaxMetrics().getAndSymbol() != null && aCliCtx.getSyntaxMetrics().getAndSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getAndSymbol() + " " : " ");
            }
            theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }
}

