/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public enum ArgsFilter {
    NONE(null),
    D(Pattern.compile("^-D[\\S\\s]*")),
    XX(Pattern.compile("^-XX:[\\S\\s]*")),
    D_XX(Pattern.compile("(^-D[\\S\\s]*)|(^-XX:[\\S\\s]*)"));

    private Pattern _pattern;

    private ArgsFilter(Pattern aArgsFilter) {
        this._pattern = aArgsFilter;
    }

    public Pattern getFilter() {
        return this._pattern;
    }

    public String[] toFiltered(String[] aArgs) {
        return ArgsFilter.toFiltered(aArgs, this._pattern);
    }

    public List<String> toFiltered(List<String> aArgs) {
        return ArgsFilter.toFiltered(aArgs, this._pattern);
    }

    public String[] fromFilter(String[] aArgs) {
        return ArgsFilter.fromFilter(aArgs, this._pattern);
    }

    public List<String> fromFilter(List<String> aArgs) {
        return ArgsFilter.fromFilter(aArgs, this._pattern);
    }

    public static String[] toFiltered(String[] aArgs, Pattern aArgsFilter) {
        if (aArgsFilter == null) {
            return aArgs;
        }
        ArrayList<String> theArgs = new ArrayList<String>();
        for (String eArg : aArgs) {
            if (aArgsFilter.matcher(eArg).matches()) continue;
            theArgs.add(eArg);
        }
        return theArgs.toArray(new String[theArgs.size()]);
    }

    public static List<String> toFiltered(List<String> aArgs, Pattern aArgsFilter) {
        if (aArgsFilter == null) {
            return aArgs;
        }
        ArrayList<String> theArgs = new ArrayList<String>();
        for (String eArg : aArgs) {
            if (aArgsFilter.matcher(eArg).matches()) continue;
            theArgs.add(eArg);
        }
        return theArgs;
    }

    public static String[] fromFilter(String[] aArgs, Pattern aArgsFilter) {
        if (aArgsFilter == null) {
            return new String[0];
        }
        ArrayList<String> theArgs = new ArrayList<String>();
        for (String eArg : aArgs) {
            if (!aArgsFilter.matcher(eArg).matches()) continue;
            theArgs.add(eArg);
        }
        return theArgs.toArray(new String[theArgs.size()]);
    }

    public static List<String> fromFilter(List<String> aArgs, Pattern aArgsFilter) {
        ArrayList<String> theArgs = new ArrayList<String>();
        if (aArgsFilter == null) {
            return theArgs;
        }
        for (String eArg : aArgs) {
            if (!aArgsFilter.matcher(eArg).matches()) continue;
            theArgs.add(eArg);
        }
        return theArgs;
    }

    public static ArgsFilter toArgsFilter(String aValue) {
        aValue = aValue != null ? aValue.replaceAll("-", "").replaceAll("_", "") : aValue;
        for (ArgsFilter eValue : ArgsFilter.values()) {
            if (!eValue.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(aValue)) continue;
            return eValue;
        }
        return null;
    }
}

