/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliSchema;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.mixin.Schema;

public class ArrayOperand<T>
implements Operand<T[]> {
    private static final String MIN_LENGTH = "MIN_LENGTH";
    private static final String MAX_LENGTH = "MAX_LENGTH";
    private Operand<T> _operand;
    private T[] _values = null;
    private int _minLength;
    private int _maxLength;
    private Class<T[]> _type;

    public ArrayOperand(Operand<T> aOperand) {
        this(aOperand, -1, -1);
    }

    public ArrayOperand(Operand<T> aOperand, int aLength) {
        this(aOperand, aLength, aLength);
    }

    public ArrayOperand(Operand<T> aOperand, int aMinLength, int aMaxLength) {
        if (aMaxLength == 0 || aMinLength != -1 && aMaxLength != -1 && aMinLength > aMaxLength || aMaxLength < -1 || aMaxLength < -1) {
            throw new IllegalArgumentException("The minimum length <" + aMinLength + "> must be less or equal than the maximum length <" + aMaxLength + ">, both values must be greater (minimum and maximum) or equal (minimum) than <0> (or <-1> when to be ignored)!");
        }
        this._operand = aOperand;
        this._minLength = aMinLength;
        this._maxLength = aMaxLength;
        this._type = Array.newInstance(aOperand.getType(), 0).getClass();
    }

    @Override
    public T[] getValue() {
        return this._values;
    }

    @Override
    public String[] toParsedArgs() {
        return this._operand.toParsedArgs();
    }

    @Override
    public String getAlias() {
        return this._operand.getAlias();
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return aCliCtx.toArgumentSpec(this, this._minLength, this._maxLength);
    }

    public Class<T[]> getType() {
        return this._type;
    }

    public List<Operand<?>> parseArgs(String[] aArgs, String[] aOperands, CliContext aCliCtx) throws ArgsSyntaxException {
        int index;
        ArrayList theOperands;
        ArrayList<T> theValues;
        block7: {
            theValues = new ArrayList<T>();
            theOperands = new ArrayList();
            try {
                for (index = 0; this._maxLength == -1 || index < this._maxLength; ++index) {
                    List eOperands = this._operand.parseArgs(aArgs, aOperands, aCliCtx);
                    for (Operand eOperand : eOperands) {
                        Object eObj;
                        try {
                            eObj = eOperand.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new ParseArgsException(aArgs, "The type <" + this._operand.getType().getSimpleName() + "> does not support cloning: " + e.getMessage(), e);
                        }
                        theOperands.add((Operand)eObj);
                    }
                    theValues.add(this._operand.getValue());
                    aArgs = CliUtility.toArgsDiff(aArgs, eOperands);
                }
            }
            catch (AmbiguousArgsException | ParseArgsException | UnknownArgsException e) {
                if (this._maxLength == -1 || index <= this._maxLength) break block7;
                throw e;
            }
        }
        if (theValues.size() == 0 || this._minLength != -1 && index < this._minLength) {
            throw new UnknownArgsException(aArgs, "Not one argument matched (as of \"" + aCliCtx.toSpec(this) + "\")");
        }
        this._values = theValues.toArray((Object[])Array.newInstance(this._operand.getType(), theValues.size()));
        return theOperands;
    }

    public void reset() {
        this._operand.reset();
        this._values = null;
    }

    public String getDescription() {
        return this._operand.getDescription();
    }

    @Override
    public int compareTo(Operand<?> o) {
        return this._operand.compareTo(o);
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public CliSchema toSchema() {
        CliSchema theSchema = new CliSchema(this._operand.getDescription(), this.getClass(), this.getValue(), this._operand.getAlias(), new Schema[0]);
        theSchema.put(MAX_LENGTH, this._maxLength);
        theSchema.put(MIN_LENGTH, this._minLength);
        return theSchema;
    }

    protected Operand<T> getOperand() {
        return this._operand;
    }
}

