/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.CliUtility;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Constituent;
import org.refcodes.cli.Operand;
import org.refcodes.cli.UnknownArgsException;

public class OrCondition
extends AbstractCondition
implements Condition {
    public OrCondition(Constituent ... aArgs) {
        super("At least one (OR) nested syntaxable must match from the arguments.", aArgs);
    }

    @Override
    public List<? extends Operand<?>> parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList theResult = null;
        for (Constituent eChild : this.getChildren()) {
            try {
                List<? extends Operand<?>> eOperands = eChild.parseArgs(aArgs, aOptions, aCliCtx);
                if (eOperands != null) {
                    if (theResult == null) {
                        theResult = new ArrayList();
                    }
                    theResult.addAll(eOperands);
                }
                aArgs = CliUtility.toArgsDiff(aArgs, eOperands);
            }
            catch (AmbiguousArgsException | UnknownArgsException argsSyntaxException) {}
        }
        if (theResult != null) {
            return theResult;
        }
        throw new UnknownArgsException(aArgs, "Not any syntax matched the provided command line arguments, though at least one elective must match.");
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        Object theSynopsis = "";
        for (Constituent eChild : this.getChildren()) {
            if (((String)theSynopsis).length() != 0) {
                theSynopsis = (String)theSynopsis + (String)(aCliCtx.getSyntaxMetrics().getOrSymbol() != null && aCliCtx.getSyntaxMetrics().getOrSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getOrSymbol() + " " : " ");
            }
            theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }

    @Override
    public String toString() {
        return this.toSchema().toString();
    }
}

