// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import org.refcodes.data.ExitCode;
import org.refcodes.exception.AbstractException;
import org.refcodes.mixin.StatusCodeAccessor;

/**
 * Base exception for the console artifact.
 *
 * @author steiner
 */
public abstract class CliException extends AbstractException {

	/**
	 * This abstract exception is the base exception for all command line
	 * argument related exceptions.
	 * 
	 * @author steiner
	 */
	public static abstract class ConsoleArgsException extends CliException implements ArgsAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////

		private String[] _args;

		// /////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new console args exception.
		 *
		 * @param aArgs the args
		 * @param aMessage The aMessage describing this exception.
		 */
		public ConsoleArgsException( String[] aArgs, String aMessage ) {
			super( aMessage );
			_args = aArgs;
		}

		/**
		 * Instantiates a new console args exception.
		 *
		 * @param aArgs the args
		 * @param aMessage The aMessage describing this exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public ConsoleArgsException( String[] aArgs, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_args = aArgs;
		}

		/**
		 * Instantiates a new console args exception.
		 *
		 * @param aArgs the args
		 * @param aMessage The aMessage describing this exception.
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 */
		public ConsoleArgsException( String[] aArgs, String aMessage, Throwable aCause ) {
			super( aMessage, aCause );
			_args = aArgs;
		}

		/**
		 * Instantiates a new console args exception.
		 *
		 * @param aArgs the args
		 * @param aMessage The aMessage describing this exception.
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public ConsoleArgsException( String[] aArgs, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_args = aArgs;
		}

		/**
		 * Instantiates a new console args exception.
		 *
		 * @param aArgs the args
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 */
		public ConsoleArgsException( String[] aArgs, Throwable aCause ) {
			super( aCause );
			_args = aArgs;
		}

		/**
		 * Instantiates a new console args exception.
		 *
		 * @param aArgs the args
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public ConsoleArgsException( String[] aArgs, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_args = aArgs;
		}

		// /////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////

		/**
		 * Gets the args.
		 *
		 * @return the args
		 */
		@Override
		public String[] getArgs() {
			return _args;
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * The Class ConsoleCliException.
	 */
	public static abstract class ConsoleCliException extends CliException implements StatusCodeAccessor<ExitCode> {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private ExitCode _exitCode;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Instantiates a new console cli exception.
		 *
		 * @param aExitCode the exit code
		 * @param aMessage The aMessage describing this exception.
		 */
		public ConsoleCliException( ExitCode aExitCode, String aMessage ) {
			super( aMessage );
			_exitCode = aExitCode;
		}

		/**
		 * Instantiates a new console cli exception.
		 *
		 * @param aExitCode the exit code
		 * @param aMessage The aMessage describing this exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public ConsoleCliException( ExitCode aExitCode, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_exitCode = aExitCode;
		}

		/**
		 * Instantiates a new console cli exception.
		 *
		 * @param aExitCode the exit code
		 * @param aMessage The aMessage describing this exception.
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 */
		public ConsoleCliException( ExitCode aExitCode, String aMessage, Throwable aCause ) {
			super( aMessage, aCause );
			_exitCode = aExitCode;
		}

		/**
		 * Instantiates a new console cli exception.
		 *
		 * @param aExitCode the exit code
		 * @param aMessage The aMessage describing this exception.
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public ConsoleCliException( ExitCode aExitCode, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_exitCode = aExitCode;
		}

		/**
		 * Instantiates a new console cli exception.
		 *
		 * @param aExitCode the exit code
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 */
		public ConsoleCliException( ExitCode aExitCode, Throwable aCause ) {
			super( aCause );
			_exitCode = aExitCode;
		}

		/**
		 * Instantiates a new console cli exception.
		 *
		 * @param aExitCode the exit code
		 * @param aCause The {@link Throwable} ({@link Exception}) causing this
		 *        exception.
		 * @param aErrorCode The error code identifying this exception.
		 */
		public ConsoleCliException( ExitCode aExitCode, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_exitCode = aExitCode;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		/**
		 * Gets the status code.
		 *
		 * @return the status code
		 */
		@Override
		public ExitCode getStatusCode() {
			return _exitCode;
		}
	}

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new console exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 */
	public CliException( String aMessage ) {
		super( aMessage );
	}

	/**
	 * Instantiates a new console exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public CliException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new console exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public CliException( String aMessage, Throwable aCause ) {
		super( aMessage, aCause );
	}

	/**
	 * Instantiates a new console exception.
	 *
	 * @param aMessage The aMessage describing this exception.
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public CliException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new console exception.
	 *
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 */
	public CliException( Throwable aCause ) {
		super( aCause );
	}

	/**
	 * Instantiates a new console exception.
	 *
	 * @param aCause The {@link Throwable} ({@link Exception}) causing this
	 *        exception.
	 * @param aErrorCode The error code identifying this exception.
	 */
	public CliException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}
}
