// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.cli;

import static org.junit.jupiter.api.Assertions.*;
import static org.refcodes.cli.CliSugar.*;

import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Test;
import org.refcodes.data.AsciiColorPalette;

public class ArgsSyntaxTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean( "log.test" );

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testConditionsByArgs() {
		String[] theArgs = new String[] { "--string1=someString", "--email=someEmail", "--token=1234567890" };

		final ArgsParser theParser = new ArgsParser();
		Flag theHelpFlag = flag( 'h', "help", "Shows the help ..." );
		Flag theVersionFlag = flag( 'v', "version", "Shows the version ..." );
		StringProperty theString1Arg = stringProperty( "string1", "..." );
		StringProperty theString2Arg = stringProperty( "string2", "..." );
		BooleanProperty theboolArg = booleanProperty( "bool", "..." );
		Flag theBoolFlag = flag( "bool", "..." );
		StringProperty theEMailArg = stringProperty( "email", "..." );
		StringProperty theNameArg = stringProperty( "name", "..." );
		StringProperty theTokenArg = stringProperty( "token", "..." );
		IntProperty theIntArg = intProperty( "int", "..." );
		DoubleProperty theDoubleArg = doubleProperty( "double", "..." );
		AndCondition theAnd;
		// @formatter:off
		Term theArgsSyntax =  cases(
			and( theString1Arg, 
				optional( theString2Arg, 
					xor( theboolArg, theBoolFlag, 
						theAnd = and( theEMailArg, theNameArg, theTokenArg ) 
					),
					theIntArg, theDoubleArg
				)
			),
			theHelpFlag,
			theVersionFlag
		);
		// @formatter:on

		theParser.withArgsSyntax( theArgsSyntax ).withName( null ).withSyntaxMetrics( SyntaxNotation.LOGICAL ).withEscapeCodesEnabled( false ).withConsoleWidth( 80 ).withBannerFontPalette( AsciiColorPalette.MAX_LEVEL_GRAY ).withLicense( null ).withCopyright( null ).withTitle( "CROWD:IT" ).withDescription( null );
		try {
			theParser.evalArgs( theArgs );
			fail( "Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!" );
		}
		catch ( ArgsSyntaxException e ) {
			Condition[] theParents = ((Condition) theParser.getArgsSyntax()).toConditions( e.getArgs() );
			if ( IS_LOG_TEST_ENABLED ) {
				System.out.println( theParents[0] );
			}
			assertEquals( 1, theParents.length );
			assertEquals( theAnd, theParents[0] );
		}
	}

	@Test
	public void testOperandsByArgs() {
		String[] theArgs = new String[] { "--string1=someString", "--email=someEmail", "--token=1234567890" };

		final ArgsParser theParser = new ArgsParser();
		Flag theHelpFlag = flag( 'h', "help", "Shows the help ..." );
		Flag theVersionFlag = flag( 'v', "version", "Shows the version ..." );
		StringProperty theString1Arg = stringProperty( "string1", "..." );
		StringProperty theString2Arg = stringProperty( "string2", "..." );
		BooleanProperty theboolArg = booleanProperty( "bool", "..." );
		Flag theBoolFlag = flag( "bool", "..." );
		StringProperty theEMailArg = stringProperty( "email", "..." );
		StringProperty theNameArg = stringProperty( "name", "..." );
		StringProperty theTokenArg = stringProperty( "token", "..." );
		IntProperty theIntArg = intProperty( "int", "..." );
		DoubleProperty theDoubleArg = doubleProperty( "double", "..." );
		// @formatter:off
		Term theArgsSyntax =  cases(
			and( theString1Arg, 
				optional( theString2Arg, 
					xor( theboolArg, theBoolFlag, 
						and( theEMailArg, theNameArg, theTokenArg ) 
					),
					theIntArg, theDoubleArg
				)
			),
			theHelpFlag,
			theVersionFlag
		);
		// @formatter:on

		theParser.withArgsSyntax( theArgsSyntax ).withName( null ).withSyntaxMetrics( SyntaxNotation.LOGICAL ).withEscapeCodesEnabled( false ).withConsoleWidth( 80 ).withBannerFontPalette( AsciiColorPalette.MAX_LEVEL_GRAY ).withLicense( null ).withCopyright( null ).withTitle( "CROWD:IT" ).withDescription( null );
		try {
			theParser.evalArgs( theArgs );
			fail( "Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!" );
		}
		catch ( ArgsSyntaxException e ) {
			Operand<?>[] theOperands = ((Condition) theParser.getArgsSyntax()).toOperands( e.getArgs() );
			if ( IS_LOG_TEST_ENABLED ) {
				for ( var eOperand : theOperands ) {
					System.out.println( eOperand );
				}
			}
			assertEquals( 3, theOperands.length );
			List<Operand<?>> theList = Arrays.asList( theOperands );
			assertTrue( theList.contains( theString1Arg ) );
			assertTrue( theList.contains( theEMailArg ) );
			assertTrue( theList.contains( theTokenArg ) );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
