/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Condition;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.Flag;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.Operand;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.data.AsciiColorPalette;

public class ArgsSyntaxTest {
    private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testConditionsByArgs() {
        String[] theArgs = new String[]{"--string1=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser theParser = new ArgsParser();
        Flag theHelpFlag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag theVersionFlag = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty theString1Arg = CliSugar.stringProperty((String)"string1", (String)"...");
        StringProperty theString2Arg = CliSugar.stringProperty((String)"string2", (String)"...");
        BooleanProperty theboolArg = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag theBoolFlag = CliSugar.flag((String)"bool", (String)"...");
        StringProperty theEMailArg = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty theNameArg = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty theTokenArg = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty theIntArg = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty theDoubleArg = CliSugar.doubleProperty((String)"double", (String)"...");
        Term[] termArray = new Term[3];
        Term[] termArray2 = new Term[2];
        termArray2[0] = theString1Arg;
        Term[] termArray3 = new Term[4];
        termArray3[0] = theString2Arg;
        Term[] termArray4 = new Term[3];
        termArray4[0] = theboolArg;
        termArray4[1] = theBoolFlag;
        AndCondition theAnd = CliSugar.and((Term[])new Term[]{theEMailArg, theNameArg, theTokenArg});
        termArray4[2] = theAnd;
        termArray3[1] = CliSugar.xor((Term[])termArray4);
        termArray3[2] = theIntArg;
        termArray3[3] = theDoubleArg;
        termArray2[1] = CliSugar.optional((Term[])termArray3);
        termArray[0] = CliSugar.and((Term[])termArray2);
        termArray[1] = theHelpFlag;
        termArray[2] = theVersionFlag;
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            Condition[] theParents = ((Condition)theParser.getArgsSyntax()).toConditions(e.getArgs());
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(theParents[0]);
            }
            Assertions.assertEquals((int)1, (int)theParents.length);
            Assertions.assertEquals((Object)theAnd, (Object)theParents[0]);
        }
    }

    @Test
    public void testOperandsByArgs() {
        String[] theArgs = new String[]{"--string1=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser theParser = new ArgsParser();
        Flag theHelpFlag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag theVersionFlag = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty theString1Arg = CliSugar.stringProperty((String)"string1", (String)"...");
        StringProperty theString2Arg = CliSugar.stringProperty((String)"string2", (String)"...");
        BooleanProperty theboolArg = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag theBoolFlag = CliSugar.flag((String)"bool", (String)"...");
        StringProperty theEMailArg = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty theNameArg = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty theTokenArg = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty theIntArg = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty theDoubleArg = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theString1Arg, CliSugar.optional((Term[])new Term[]{theString2Arg, CliSugar.xor((Term[])new Term[]{theboolArg, theBoolFlag, CliSugar.and((Term[])new Term[]{theEMailArg, theNameArg, theTokenArg})}), theIntArg, theDoubleArg})}), theHelpFlag, theVersionFlag});
        theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            Operand[] theOperands = ((Condition)theParser.getArgsSyntax()).toOperands(e.getArgs());
            if (IS_LOG_TEST_ENABLED) {
                for (Operand eOperand : theOperands) {
                    System.out.println(eOperand);
                }
            }
            Assertions.assertEquals((int)3, (int)theOperands.length);
            List<Operand> theList = Arrays.asList(theOperands);
            Assertions.assertTrue((boolean)theList.contains(theString1Arg));
            Assertions.assertTrue((boolean)theList.contains(theEMailArg));
            Assertions.assertTrue((boolean)theList.contains(theTokenArg));
        }
    }
}

