/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import org.refcodes.cli.AbstractCondition;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Condition;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Term;

public class AndCondition
extends AbstractCondition
implements Condition {
    public AndCondition(Term ... aArgs) {
        super("All (AND) syntax branches must match from the provided command line arguments.", aArgs);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aOptions, CliContext aCliCtx) throws ArgsSyntaxException {
        ArrayList theResult = new ArrayList();
        ArgsSyntaxException theCause = null;
        for (Term eChild : this._children) {
            try {
                Operand<?>[] eOperands = eChild.parseArgs(aArgs, aOptions, aCliCtx);
                if (eOperands != null && eOperands.length != 0) {
                    for (Operand<?> eOperand : eOperands) {
                        theResult.add(eOperand);
                    }
                }
                aArgs = AndCondition.toArgsDiff(aArgs, eOperands);
            }
            catch (ArgsSyntaxException e) {
                if (theCause == null) {
                    theCause = e;
                    continue;
                }
                theCause.addSuppressed((Throwable)((Object)e));
            }
        }
        if (theCause != null) {
            this._exception = new ArgsSyntaxException(aArgs, "At least one syntax branch did not match the command line arguments, though all (AND) syntax branches must be matched by the command line arguments!", (Throwable)((Object)theCause), (Term)this);
            throw this._exception;
        }
        return theResult.toArray(new Operand[theResult.size()]);
    }

    @Override
    public String toSynopsis(CliContext aCliCtx) {
        Object theSynopsis = "";
        for (Term eChild : this._children) {
            if (((String)theSynopsis).length() != 0) {
                theSynopsis = (String)theSynopsis + (String)(aCliCtx.getSyntaxMetrics().getAndSymbol() != null && aCliCtx.getSyntaxMetrics().getAndSymbol().length() != 0 ? " " + aCliCtx.getSyntaxMetrics().getAndSymbol() + " " : " ");
            }
            theSynopsis = (String)theSynopsis + eChild.toSyntax(aCliCtx);
        }
        return theSynopsis;
    }

    @Override
    public String toSyntax(CliContext aCliCtx) {
        return this.toSynopsis(aCliCtx);
    }
}

