/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.ArgsFilter;

public class ArgsFilterTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testNoneFilter1() {
        String[] theArgs = new String[]{"-Dconsole.width=130", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-Dconsole.width=130", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.NONE, theArgs, theExpected);
    }

    @Test
    public void testNoneFilter2() {
        String[] theArgs = new String[]{"-Dconsole.width=130\n", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-Dconsole.width=130\n", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.NONE, theArgs, theExpected);
    }

    @Test
    public void testDFilter1() {
        String[] theArgs = new String[]{"-Dconsole.width=130", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, theArgs, theExpected);
    }

    @Test
    public void testDFilter2() {
        String[] theArgs = new String[]{"-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, theArgs, theExpected);
    }

    @Test
    public void testDFilter3() {
        String[] theArgs = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, theArgs, theExpected);
    }

    @Test
    public void testDFilter4() {
        String[] theArgs = new String[]{"-a", "-b", "<someB>", "--Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "--Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, theArgs, theExpected);
    }

    @Test
    public void testDFilter5() {
        String[] theArgs = new String[]{"-a", "-b", "<someB>", "Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, theArgs, theExpected);
    }

    @Test
    public void testDFilter6() {
        String[] theArgs = new String[]{"-Dconsole.width=130", "-Dconsole.linebreak=\n", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D, theArgs, theExpected);
    }

    @Test
    public void testXXFilter1() {
        String[] theArgs = new String[]{"-XX:codecachetotal", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.XX, theArgs, theExpected);
    }

    @Test
    public void testXXFilter2() {
        String[] theArgs = new String[]{"-XXwhatever", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-XXwhatever", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.XX, theArgs, theExpected);
    }

    @Test
    public void testDXXFilter1() {
        String[] theArgs = new String[]{"-XX:codecachetotal", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D_XX, theArgs, theExpected);
    }

    @Test
    public void testDXXFilter2() {
        String[] theArgs = new String[]{"-XXwhatever", "-XX:codecachetotal", "-a", "-b", "<someB>", "-Dlog.debug=true", "<somePath>"};
        String[] theExpected = new String[]{"-XXwhatever", "-a", "-b", "<someB>", "<somePath>"};
        ArgsFilterTest.validate(ArgsFilter.D_XX, theArgs, theExpected);
    }

    private static void validate(ArgsFilter aArgsFilter, String[] aArgs, String[] aExpected) {
        Object[] theResult = aArgsFilter.toFiltered(aArgs);
        List<String> theList = Arrays.asList(aArgs);
        List theFiltered = aArgsFilter.toFiltered(theList);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Args := " + Arrays.toString(aArgs));
            System.out.println("Expected := " + Arrays.toString(aExpected));
            System.out.println("Result := " + Arrays.toString(theResult));
            System.out.println("Filtered := " + theFiltered);
            System.out.println();
        }
        Assertions.assertArrayEquals((Object[])aExpected, (Object[])theResult);
        Assertions.assertArrayEquals((Object[])aExpected, (Object[])theFiltered.toArray(new String[theFiltered.size()]));
    }
}

