/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AllCondition;
import org.refcodes.cli.AmbiguousArgsException;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.AnyCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.BooleanOption;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.ConfigOption;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.Operand;
import org.refcodes.cli.Operation;
import org.refcodes.cli.Option;
import org.refcodes.cli.OrCondition;
import org.refcodes.cli.ParseArgs;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.StringOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SuperfluousArgsException;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.cli.XorCondition;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.Execution;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsParserTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");
    private static final String[][] ARGS = new String[][]{{"--name", "FILE", "--boolean", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "FILE", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "FILE", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static final String[][] PROPERTIES = new String[][]{{"name=FILE", "boolean=true", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "active=true"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=FILE", "boolean=true", "alias=ALIAS"}, {"name=FILE", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testEdgeCase1() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theInputFileArg, theOutputFileArg, CliSugar.any((Term[])new Term[]{theDebugFlag})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{theSysInfoFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})})});
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        theParser.evalArgs(new String[]{"-i", "in", "-o", "out"});
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theCondition.toSchema());
        }
    }

    @Test
    public void testEdgeCase2() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theInputFileArg, theOutputFileArg, CliSugar.any((Term[])new Term[]{theDebugFlag})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{theSysInfoFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})})});
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        try {
            theParser.evalArgs(new String[0]);
            Assertions.fail((String)("Expected an <" + UnknownArgsException.class.getName() + ">!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeCase3() throws ArgsSyntaxException {
        EnumOption theEncodingArg = CliSugar.enumOption((String)"--encoding", BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])BaseMetricsConfig.values())));
        Flag theBase64Flag = CliSugar.flag((String)"--base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag theDecryptFlag = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the aMessage (stream, file, text or bytes).");
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the aMessage (stream, file, text or bytes).");
        Flag theVerifyFlag = CliSugar.flag((String)"--verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        IntOption theLineWidthArg = CliSugar.intOption((String)"--line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        AndCondition theCondition = CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEncryptFlag, CliSugar.any((Term[])new Term[]{theVerifyFlag, CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theBase64Flag, CliSugar.any((Term[])new Term[]{theLineWidthArg})}), CliSugar.and((Term[])new Term[]{theEncodingArg, CliSugar.any((Term[])new Term[]{theLineWidthArg})})})})}), theDecryptFlag}), CliSugar.any((Term[])new Term[]{theInputFileArg, theOutputFileArg})});
        String[] args = new String[]{"-e", "-i", "input.dat", "-o", "output.txt"};
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        theParser.evalArgs(args);
    }

    @Test
    public void testEdgeCase4() throws ArgsSyntaxException {
        EnumOption theChaosModeArg = CliSugar.enumOption((String)"--chaos-mode", ChaosMode.class, (String)"CHAOS_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ChaosMode.values())));
        EnumOption theContextArg = CliSugar.enumOption((String)"--context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag thePromptPasswordFlag = CliSugar.flag((String)"--prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        StringOption theCertFileArg = CliSugar.stringOption((Character)Character.valueOf('c'), (String)"cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption thePasswordArg = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, thePasswordArg, theContextArg})})})})});
        String[] args = new String[]{"-p", "Hallo Welt!", "--cert-file", "C"};
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        theParser.evalArgs(args);
    }

    @Test
    public void testEdgeCase5() throws ArgsSyntaxException {
        StringOption theEchoOption = CliSugar.stringOption((Character)Character.valueOf('e'), (String)"echo", (String)"TEXT_PROPERTY", (String)"Echoes the provided aMessage to the standard out stream.");
        ConfigOption theConfigOption = CliSugar.configOption();
        InitFlag theInitFlag = CliSugar.initFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag();
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEchoOption, CliSugar.any((Term[])new Term[]{theConfigOption, theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theInitFlag, CliSugar.any((Term[])new Term[]{theConfigOption, theVerboseFlag})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{theSysInfoFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})})});
        String[] args = new String[]{};
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        try {
            theParser.evalArgs(args);
            Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getSimpleName() + "> exception!"));
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testEdgeCase6() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theInputFileArg, CliSugar.and((Term[])new Term[]{theOutputFileArg, CliSugar.any((Term[])new Term[]{theVerboseFlag})}), theDebugFlag}), CliSugar.and((Term[])new Term[]{theInputFileArg, CliSugar.and((Term[])new Term[]{theDebugFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{theSysInfoFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})})});
        String[] args = new String[]{"-i", "someInputFile", "-o", "someOutputFile"};
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        theParser.evalArgs(args);
    }

    @Test
    public void testEdgeCase7() throws ArgsSyntaxException {
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUTFILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUTFILE_PROPERTY", (String)"The output file which to process to.");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theInputFileArg, CliSugar.and((Term[])new Term[]{theOutputFileArg, CliSugar.any((Term[])new Term[]{theVerboseFlag})}), theDebugFlag}), CliSugar.and((Term[])new Term[]{theInputFileArg, CliSugar.and((Term[])new Term[]{theDebugFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{theSysInfoFlag, CliSugar.any((Term[])new Term[]{theVerboseFlag})})})});
        String[] args = new String[]{"-i", "someInputFile"};
        ArgsParser theParser = new ArgsParser((Term)theCondition);
        Operand[] theOperands = theParser.evalArgs(args);
        Assertions.assertEquals((int)1, (int)theOperands.length);
        Assertions.assertEquals((Object)"someInputFile", (Object)theInputFileArg.getValue());
    }

    @Test
    public void testEdgeCase8() {
        StringProperty theFileNameArg = CliSugar.stringProperty((Character)Character.valueOf('f'), (String)"filename", (String)"The kernel's project file");
        StringProperty theCsvNameArg = CliSugar.stringProperty((String)"csv", (String)"The kernel's poulation CSV file");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theFileNameArg, CliSugar.optional((Term[])new Term[]{theCsvNameArg})})});
        ArgsParser theParser = new ArgsParser((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            theParser.evalArgs(new String[]{"-f=filename", "--csv=csv"});
        }
        catch (ArgsSyntaxException e) {
            theParser.printBody();
            System.out.println(e.toMessage());
        }
    }

    @Test
    public void testAnyCase1() {
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        QuietFlag theQuietFlag = CliSugar.quietFlag();
        CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{};
        ArgsParser theParser = new ArgsParser((Term)theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.toMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)theDebugFlag.isEnabled());
        Assertions.assertFalse((boolean)theVerboseFlag.isEnabled());
        Assertions.assertFalse((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase2() {
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)true);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag((boolean)true);
        QuietFlag theQuietFlag = CliSugar.quietFlag((boolean)true);
        CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{"-q"};
        ArgsParser theParser = new ArgsParser((Term)theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.toMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertFalse((boolean)theDebugFlag.isEnabled());
        Assertions.assertFalse((boolean)theVerboseFlag.isEnabled());
        Assertions.assertTrue((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase3() {
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)true);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag((boolean)true);
        QuietFlag theQuietFlag = CliSugar.quietFlag((boolean)true);
        CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{"-d", "-v"};
        ArgsParser theParser = new ArgsParser((Term)theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.toMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)theDebugFlag.isEnabled());
        Assertions.assertTrue((boolean)theVerboseFlag.isEnabled());
        Assertions.assertFalse((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase4() {
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)true);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag((boolean)true);
        QuietFlag theQuietFlag = CliSugar.quietFlag((boolean)true);
        CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
        String[] args = new String[]{"-d"};
        ArgsParser theParser = new ArgsParser((Term)theRoot);
        try {
            theParser.evalArgs(args);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(e.toMessage());
                e.printStackTrace();
            }
            Assertions.fail((String)e.getMessage());
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
        Assertions.assertTrue((boolean)theDebugFlag.isEnabled());
        Assertions.assertFalse((boolean)theVerboseFlag.isEnabled());
        Assertions.assertFalse((boolean)theQuietFlag.isEnabled());
    }

    @Test
    public void testAnyCase5() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-q", "-d"};
            ArgsParser theParser = new ArgsParser((Term)theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.toMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase6() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-v", "-q"};
            ArgsParser theParser = new ArgsParser((Term)theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.toMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyCase7() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag();
            theVerboseFlag = CliSugar.verboseFlag();
            theQuietFlag = CliSugar.quietFlag();
            CasesCondition theRoot = CliSugar.cases((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-d", "-v", "-q"};
            ArgsParser theParser = new ArgsParser((Term)theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + UnknownArgsException.class.getName() + "> exception!"));
            }
            catch (UnknownArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.toMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testAnyXor1() throws ArgsSyntaxException {
        QuietFlag theQuietFlag;
        VerboseFlag theVerboseFlag;
        DebugFlag theDebugFlag;
        block3: {
            theDebugFlag = CliSugar.debugFlag((boolean)true);
            theVerboseFlag = CliSugar.verboseFlag((boolean)true);
            theQuietFlag = CliSugar.quietFlag((boolean)true);
            XorCondition theRoot = CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{theDebugFlag, theVerboseFlag}), theQuietFlag});
            String[] args = new String[]{"-q", "-d"};
            ArgsParser theParser = new ArgsParser((Term)theRoot);
            try {
                theParser.evalArgs(args);
                Assertions.fail((String)("Expected a <" + AmbiguousArgsException.class.getName() + "> exception!"));
            }
            catch (AmbiguousArgsException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.toMessage());
            }
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theDebugFlag.getAlias() + " := " + theDebugFlag.isEnabled());
            System.out.println(theVerboseFlag.getAlias() + " := " + theVerboseFlag.isEnabled());
            System.out.println(theQuietFlag.getAlias() + " := " + theQuietFlag.isEnabled());
        }
    }

    @Test
    public void testParser1() throws ArgsSyntaxException {
        StringOption theFile = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser2() throws ArgsSyntaxException {
        StringOption theFile = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AnyCondition theOptional = new AnyCondition(new Term[]{theXor});
        AndCondition theAnd = new AndCondition(new Term[]{theOptional, theFile});
        String[] args = new String[]{"-f", "someFile", "-d"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theAnd.toSynopsis());
        }
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertFalse((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser3() throws ArgsSyntaxException {
        StringOption theFile = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser4() throws ArgsSyntaxException {
        StringOption theFile = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            // empty catch block
        }
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser5() throws ArgsSyntaxException {
        StringOption theFile = new StringOption(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException e) {
            Assertions.assertEquals((int)1, (int)e.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)e.getArgs()[0]);
        }
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser6() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser7() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser8() {
        StringOption theFromFile = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringOption theToFile = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theDelete, theAdd});
        AndCondition theAnd = new AndCondition(new Term[]{theOperand, theXor, theFromFile, theToFile});
        Operand[] theOperands = theAnd.toOperands();
        this.doLogOperands(theOperands);
    }

    @Test
    public void testParser9() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption(Character.valueOf('f'), "from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail braking.");
        StringOption theToFile = new StringOption(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theCreate = new Flag(Character.valueOf('c'), null, null, "Creates the specified file");
        OrCondition theOrArgsSyntax = new OrCondition(new Term[]{theAdd, theCreate});
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Term[]{theOrArgsSyntax, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser10() throws ArgsSyntaxException {
        BooleanOption theBool1 = new BooleanOption("bool1", "The 1st boolean");
        BooleanOption theBool2 = new BooleanOption("bool2", "The 2nd boolean");
        BooleanOption theBool3 = new BooleanOption("bool3", "The 3rd boolean");
        BooleanOption theBool4 = new BooleanOption("bool4", "The 4th boolean");
        AndCondition theAnd = new AndCondition(new Term[]{theBool1, theBool2, theBool3, theBool4});
        String[] args = new String[]{"--bool1", "true", "--bool2", "on", "--bool3", "yes", "--bool4", "1"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)theBool1.getValue());
        Assertions.assertTrue((boolean)theBool2.getValue());
        Assertions.assertTrue((boolean)theBool3.getValue());
        Assertions.assertTrue((boolean)theBool4.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParser11() throws ArgsSyntaxException {
        BooleanOption theBool1 = CliSugar.booleanOption((String)"bool1", (String)"The 1st boolean");
        BooleanOption theBool2 = CliSugar.booleanOption((String)"bool2", (String)"The 2nd boolean");
        BooleanOption theBool3 = CliSugar.booleanOption((String)"bool3", (String)"The 3rd boolean");
        BooleanOption theBool4 = CliSugar.booleanOption((String)"bool4", (String)"The 4th boolean");
        AndCondition theAnd = CliSugar.and((Term[])new Term[]{theBool1, theBool2, theBool3, theBool4});
        String[] args = new String[]{"--bool1", "false", "--bool2", "off", "--bool3", "no", "--bool4", "0"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertFalse((boolean)theBool1.getValue());
        Assertions.assertFalse((boolean)theBool2.getValue());
        Assertions.assertFalse((boolean)theBool3.getValue());
        Assertions.assertFalse((boolean)theBool4.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties1() throws ArgsSyntaxException {
        StringProperty theFile = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile});
        String[] args = new String[]{"-f=someFile", "-a"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties2() throws ArgsSyntaxException {
        StringProperty theFile = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AnyCondition theOptional = new AnyCondition(new Term[]{theXor});
        AndCondition theAnd = new AndCondition(new Term[]{theOptional, theFile});
        String[] args = new String[]{"-f=someFile", "-d"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theAnd.toSynopsis());
        }
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertFalse((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties3() throws ArgsSyntaxException {
        StringProperty theFile = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f=someFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties4() throws ArgsSyntaxException {
        StringProperty theFile = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f=someFile", "-a"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (ArgsSyntaxException argsSyntaxException) {
            // empty catch block
        }
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties5() throws ArgsSyntaxException {
        StringProperty theFile = new StringProperty(Character.valueOf('f'), "file", "file", "The file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f=someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expecting an exception");
        }
        catch (SuperfluousArgsException e) {
            Assertions.assertEquals((int)1, (int)e.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)e.getArgs()[0]);
        }
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties6() throws ArgsSyntaxException {
        StringProperty theFromFile = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringProperty theToFile = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f=fromFile", "-t=toFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties7() throws ArgsSyntaxException {
        StringProperty theFromFile = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringProperty theToFile = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theAdd, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-t=toFile", "anOperand", "-f=fromFile", "-a"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties8() {
        StringProperty theFromFile = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed");
        StringProperty theToFile = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed");
        XorCondition theXor = new XorCondition(new Term[]{theDelete, theAdd});
        AndCondition theAnd = new AndCondition(new Term[]{theOperand, theXor, theFromFile, theToFile});
        Operand[] theOperands = theAnd.toOperands();
        this.doLogOperands(theOperands);
    }

    @Test
    public void testParserWithProperties9() throws ArgsSyntaxException {
        StringProperty theFromFile = new StringProperty(Character.valueOf('f'), "from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail braking.");
        StringProperty theToFile = new StringProperty(Character.valueOf('t'), "to", "to_file", "The destination file to be processed");
        Flag theAdd = new Flag(Character.valueOf('a'), null, null, "Add the specified file");
        Flag theCreate = new Flag(Character.valueOf('c'), null, null, "Creates the specified file");
        OrCondition theOrArgsSyntax = new OrCondition(new Term[]{theAdd, theCreate});
        Flag theDelete = new Flag(Character.valueOf('d'), null, null, "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Term[]{theOrArgsSyntax, theDelete});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f=fromFile", "-t=toFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties10() throws ArgsSyntaxException {
        BooleanProperty theBool1 = new BooleanProperty("bool1", "The 1st boolean");
        BooleanProperty theBool2 = new BooleanProperty("bool2", "The 2nd boolean");
        BooleanProperty theBool3 = new BooleanProperty("bool3", "The 3rd boolean");
        BooleanProperty theBool4 = new BooleanProperty("bool4", "The 4th boolean");
        AndCondition theAnd = new AndCondition(new Term[]{theBool1, theBool2, theBool3, theBool4});
        String[] args = new String[]{"--bool1=true", "--bool2=on", "--bool3=yes", "--bool4=1"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertTrue((boolean)theBool1.getValue());
        Assertions.assertTrue((boolean)theBool2.getValue());
        Assertions.assertTrue((boolean)theBool3.getValue());
        Assertions.assertTrue((boolean)theBool4.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testParserWithProperties11() throws ArgsSyntaxException {
        BooleanProperty theBool1 = CliSugar.booleanProperty((String)"bool1", (String)"The 1st boolean");
        BooleanProperty theBool2 = CliSugar.booleanProperty((String)"bool2", (String)"The 2nd boolean");
        BooleanProperty theBool3 = CliSugar.booleanProperty((String)"bool3", (String)"The 3rd boolean");
        BooleanProperty theBool4 = CliSugar.booleanProperty((String)"bool4", (String)"The 4th boolean");
        AndCondition theAnd = CliSugar.and((Term[])new Term[]{theBool1, theBool2, theBool3, theBool4});
        String[] args = new String[]{"--bool1=false", "--bool2=off", "--bool3=no", "--bool4=0"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        Operand[] theResult = theParseArgs.evalArgs(args);
        Assertions.assertFalse((boolean)theBool1.getValue());
        Assertions.assertFalse((boolean)theBool2.getValue());
        Assertions.assertFalse((boolean)theBool3.getValue());
        Assertions.assertFalse((boolean)theBool4.getValue());
        this.doLogArgs((ParseArgs)theParseArgs, args);
    }

    @Test
    public void testAliasSyntaxTreeLookup() throws ArgsSyntaxException {
        StringOption theFromFile = new StringOption(Character.valueOf('f'), "from", "from", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail braking.");
        StringOption theToFile = new StringOption(Character.valueOf('t'), "to", "to", "The destination file to be processed");
        Flag theAddFile = new Flag(Character.valueOf('a'), "--add", "add", "Add the specified file");
        Flag theCreateFile = new Flag(Character.valueOf('c'), "create", "create", "Creates the specified file");
        OrCondition theOrArgsSyntax = new OrCondition(new Term[]{theAddFile, theCreateFile});
        Flag theDeleteFile = new Flag(Character.valueOf('d'), "delete", "delete", "Delete the specified file");
        StringOperand theOperand = new StringOperand("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorCondition theXor = new XorCondition(new Term[]{theOrArgsSyntax, theDeleteFile});
        AndCondition theAnd = new AndCondition(new Term[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParser theParseArgs = new ArgsParser((Term)theAnd);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theAnd.toSynopsis());
        }
        theParseArgs.evalArgs(args);
        String theFrom = (String)theAnd.toValue("from");
        String theTo = (String)theAnd.toValue("to");
        boolean theAdd = (Boolean)theAnd.toValue("add");
        boolean theCreate = (Boolean)theAnd.toValue("create");
        boolean theDelete = (Boolean)theAnd.toValue("delete");
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("From := " + theFrom);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("To := " + theTo);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Add := " + theAdd);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Create := " + theCreate);
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Delete := " + theDelete);
        }
        Assertions.assertEquals((Object)"fromFile", (Object)theFrom);
        Assertions.assertEquals((Object)"toFile", (Object)theTo);
        Assertions.assertTrue((boolean)theAdd);
        Assertions.assertFalse((boolean)theCreate);
        Assertions.assertFalse((boolean)theDelete);
    }

    @Test
    public void testArgsProperties() throws ArgsSyntaxException {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Test
    public void testProductionError() throws ArgsSyntaxException {
        String[] args = new String[]{"-l", "1", "-s", "100", "-f", "1"};
        DoubleOption theFrequencyOpt = CliSugar.doubleOption((Character)Character.valueOf('f'), (String)"frequency", (String)"FREQUENCY_HZ", (String)"The frequency (Hz) to use when generating the values.");
        IntOption theSamplingRateOpt = CliSugar.intOption((Character)Character.valueOf('s'), (String)"sampling-rate", (String)"SAMPLING_RATE", (String)"The sample rate (per second) for the generated values (defaults to DEFAULT_SAMPLING_RATE_PER_SEC samples/second).");
        DoubleOption theLengthOpt = CliSugar.doubleOption((Character)Character.valueOf('l'), (String)"length", (String)"LENGTH_SEC", (String)"The length (in seconds) for the generated values (defaults to DFAULT_LENGTH_SEC seconds).");
        AndCondition theRoot = CliSugar.and((Term[])new Term[]{theFrequencyOpt, CliSugar.any((Term[])new Term[]{theLengthOpt, theSamplingRateOpt})});
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.withName("Waves").withTitle("~waves~").withCopyright("Copyright (c) by FUNCODES.CLUB, Munich, Germany.").withLicense("Licensed under GNU General Public License, v3.0 and Apache License, v2.0");
        theParseArgs.withBannerFont(new Font(FontFamily.DIALOG, FontStyle.BOLD)).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        theParseArgs.withDescription("Generate (sound) wave tables for given frequencies and amplitudes. Export them as CSV for further processing. Makes heavy use of the  REFCODES.ORG artifacts found together with the FUNCODES.CLUB sources at <http://bitbucket.org/refcodes>.");
        theParseArgs.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theRoot.toSchema());
        }
    }

    @Test
    public void testXorEdgeCase1() throws ArgsSyntaxException {
        StringOption theTextArg = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text aMessage which to process.");
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given aMessage.");
        XorCondition theCondition = CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEncryptFlag, theTextArg}), new AllCondition((Term)theEncryptFlag)});
        String[] args = new String[]{"-t", "text", "-e"};
        ArgsParser theParseArgs = new ArgsParser((Term)theCondition);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.evalArgs(args);
        Assertions.assertEquals((Object)"text", (Object)theTextArg.getValue());
    }

    @Test
    public void testXorEdgeCase2() throws ArgsSyntaxException {
        StringOption theTextArg = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text aMessage which to process.");
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the given aMessage.");
        CasesCondition theCondition = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theEncryptFlag, theTextArg}), theEncryptFlag});
        String[] args = new String[]{"-t", "text", "-e"};
        ArgsParser theParseArgs = new ArgsParser((Term)theCondition);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.evalArgs(args);
        Assertions.assertEquals((Object)"text", (Object)theTextArg.getValue());
    }

    @Test
    public void testArrayOption1() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 1, 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)theArray);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        for (int i = 0; i < ((String[])theArray.getValue()).length; ++i) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption2() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)theArray);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption3() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3", "-t", "text4"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 1, 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)theArray);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expected an <SuperfluousArgsException>!");
        }
        catch (SuperfluousArgsException superfluousArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption4() throws ArgsSyntaxException {
        String[] args = new String[]{};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"), 1, 3);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)theArray);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        try {
            theParseArgs.evalArgs(args);
            Assertions.fail((String)"Expected an <UnknownArgsException>!");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayOption5() throws ArgsSyntaxException {
        String[] args = new String[]{};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)new AnyCondition(new Term[]{theArray}));
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        Assertions.assertFalse((boolean)theArray.hasValue());
        Assertions.assertNull((Object)theArray.getValue());
    }

    @Test
    public void testArrayOption6() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)theArray);
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        for (int i = 0; i < ((String[])theArray.getValue()).length; ++i) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
        }
    }

    @Test
    public void testArrayOption7() throws ArgsSyntaxException {
        String[] args = new String[]{"-t", "text1", "-t", "text2", "-t", "text3"};
        ArrayOption theArray = new ArrayOption((Option)new StringOption(Character.valueOf('t'), "text", "text", "A text"));
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(theArray.toSynopsis());
        }
        ArgsParser theParseArgs = new ArgsParser((Term)new AnyCondition(new Term[]{theArray}));
        theParseArgs.withSyntaxMetrics(SyntaxNotation.LOGICAL);
        theParseArgs.evalArgs(args);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Arrays.toString(theArray.getValue()));
        }
        for (int i = 0; i < ((String[])theArray.getValue()).length; ++i) {
            Assertions.assertEquals((Object)args[i * 2 + 1], (Object)((String[])theArray.getValue())[i]);
        }
        Assertions.assertEquals((int)(args.length / 2), (int)((String[])theArray.getValue()).length);
    }

    @Test
    public void testOperation1() throws ArgsSyntaxException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        VerboseFlag verbose = new VerboseFlag();
        XorCondition theRoot = new XorCondition(new Term[]{new AndCondition(new Term[]{ls, verbose}), cd});
        String[] theArgs = new String[]{"ls", "--verbose"};
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.evalArgs(theArgs);
        Assertions.assertTrue((boolean)ls.isEnabled());
        Assertions.assertTrue((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        theRoot.reset();
        theArgs = new String[]{"cd"};
        theParseArgs.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertTrue((boolean)cd.isEnabled());
    }

    @Test
    public void testNone1() throws ArgsSyntaxException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        NoneOperand none = new NoneOperand("none", "No arguments at all");
        VerboseFlag verbose = new VerboseFlag(true);
        XorCondition theRoot = new XorCondition(new Term[]{none, new AndCondition(new Term[]{ls, verbose}), cd});
        String[] theArgs = new String[]{"ls", "--verbose"};
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.evalArgs(theArgs);
        Assertions.assertTrue((boolean)ls.isEnabled());
        Assertions.assertTrue((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        theRoot.reset();
        theArgs = new String[]{"cd"};
        theParseArgs.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertTrue((boolean)cd.isEnabled());
        Assertions.assertFalse((boolean)none.isEnabled());
    }

    @Test
    public void testNone2() throws ArgsSyntaxException {
        Operation ls = new Operation("ls", "List all entries");
        Operation cd = new Operation("cd", "Change direcory");
        NoneOperand none = new NoneOperand("none", "No arguments at all");
        VerboseFlag verbose = new VerboseFlag();
        XorCondition theRoot = new XorCondition(new Term[]{none, new AndCondition(new Term[]{ls, verbose}), cd});
        String[] theArgs = new String[]{};
        ArgsParser theParseArgs = new ArgsParser((Term)theRoot);
        theParseArgs.evalArgs(theArgs);
        Assertions.assertFalse((boolean)ls.isEnabled());
        Assertions.assertFalse((boolean)verbose.isEnabled());
        Assertions.assertFalse((boolean)cd.isEnabled());
        Assertions.assertTrue((boolean)none.isEnabled());
    }

    private void testArgs(int i) throws ArgsSyntaxException {
        String[] theExcepcted;
        ArgsParser theParseArgs = new ArgsParser();
        HashMap<String, CallSite> theProperties = new HashMap<String, CallSite>();
        String[] theArgs = ARGS[i];
        Operand[] theOperands = theParseArgs.evalArgs(theArgs);
        for (Operand eOperand : theOperands) {
            theProperties.put(eOperand.getAlias(), (CallSite)((Object)("" + eOperand.getValue())));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("Line <" + i + ">:");
        }
        for (String eKey : theProperties.keySet()) {
            if (!IS_LOG_TEST_ENABLED) continue;
            System.out.println(eKey + " := " + (String)theProperties.get(eKey));
        }
        for (String aTheExcepcted : theExcepcted = PROPERTIES[i]) {
            PropertyImpl eProperty = new PropertyImpl(aTheExcepcted);
            if ("null".equals(eProperty.getKey())) {
                eProperty = new PropertyImpl(null, (String)eProperty.getValue());
            }
            Assertions.assertEquals((Object)eProperty.getValue(), theProperties.get(eProperty.getKey()), (String)("Line <" + i + "> (" + eProperty.toString() + ")"));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogArgs(ParseArgs aParseArgs, String[] aArgs) {
        Term theArgsSyntax = aParseArgs.getArgsSyntax();
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Execution.getCallerStackTraceElement().getMethodName());
        }
        ((ParseArgs)aParseArgs.withSyntaxMetrics(SyntaxNotation.GNU_POSIX)).printHelp();
        if (IS_LOG_TEST_ENABLED) {
            for (SyntaxNotation eNotation : SyntaxNotation.values()) {
                System.out.println("[" + eNotation + " SYNTAX NOTATION]  " + theArgsSyntax.toSynopsis(eNotation));
            }
            System.out.println("[COMMAND LINE ARGS] " + new VerboseTextBuilder().withElements((Object[])aArgs).toString());
            System.out.println("[INTERNAL STATUS] " + theArgsSyntax.toString());
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    private void doLogOperands(Operand<?>[] aOperands) {
        Arrays.sort(aOperands);
        if (IS_LOG_TEST_ENABLED) {
            System.out.println(Execution.getCallerStackTraceElement().getMethodName());
        }
        for (Operand<?> eOperand : aOperands) {
            if (!IS_LOG_TEST_ENABLED) continue;
            System.out.println("[OPERAND] " + eOperand.toSyntax(SyntaxNotation.LOGICAL));
        }
        if (IS_LOG_TEST_ENABLED) {
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    static enum BaseMetricsConfig {
        A,
        B,
        C;

    }

    static enum ChaosMode {
        X,
        Y,
        Z;

    }

    static enum SystemContext {
        S0,
        S1,
        S2;

    }

    static enum TrigonometricFunction {
        SINE,
        COSINE;

    }
}

