/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.cli.AndCondition;
import org.refcodes.cli.ArgsParser;
import org.refcodes.cli.ArgsParserTest;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.BooleanProperty;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.Condition;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.DoubleProperty;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.IntProperty;
import org.refcodes.cli.LongOption;
import org.refcodes.cli.Operand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.StringProperty;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.Term;
import org.refcodes.cli.UnknownArgsException;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.runtime.SystemContext;
import org.refcodes.textual.VerboseTextBuilder;

public class ArgsSyntaxTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testConditionsByArgs() {
        String[] theArgs = new String[]{"--string1=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser theParser = new ArgsParser();
        Flag theHelpFlag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag theVersionFlag = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty theString1Arg = CliSugar.stringProperty((String)"string1", (String)"...");
        StringProperty theString2Arg = CliSugar.stringProperty((String)"string2", (String)"...");
        BooleanProperty theboolArg = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag theBoolFlag = CliSugar.flag((String)"bool", (String)"...");
        StringProperty theEMailArg = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty theNameArg = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty theTokenArg = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty theIntArg = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty theDoubleArg = CliSugar.doubleProperty((String)"double", (String)"...");
        Term[] termArray = new Term[3];
        Term[] termArray2 = new Term[2];
        termArray2[0] = theString1Arg;
        Term[] termArray3 = new Term[4];
        termArray3[0] = theString2Arg;
        Term[] termArray4 = new Term[3];
        termArray4[0] = theboolArg;
        termArray4[1] = theBoolFlag;
        AndCondition theAnd = CliSugar.and((Term[])new Term[]{theEMailArg, theNameArg, theTokenArg});
        termArray4[2] = theAnd;
        termArray3[1] = CliSugar.xor((Term[])termArray4);
        termArray3[2] = theIntArg;
        termArray3[3] = theDoubleArg;
        termArray2[1] = CliSugar.optional((Term[])termArray3);
        termArray[0] = CliSugar.and((Term[])termArray2);
        termArray[1] = theHelpFlag;
        termArray[2] = theVersionFlag;
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])termArray);
        theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            Condition[] theParents = ((Condition)theParser.getArgsSyntax()).toConditions(e.getArgs());
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(theParents[0]);
            }
            Assertions.assertEquals((int)1, (int)theParents.length);
            Assertions.assertEquals((Object)theAnd, (Object)theParents[0]);
        }
    }

    @Test
    public void testOperandsByArgs() {
        String[] theArgs = new String[]{"--string1=someString", "--email=someEmail", "--token=1234567890"};
        ArgsParser theParser = new ArgsParser();
        Flag theHelpFlag = CliSugar.flag((Character)Character.valueOf('h'), (String)"help", (String)"Shows the help ...");
        Flag theVersionFlag = CliSugar.flag((Character)Character.valueOf('v'), (String)"version", (String)"Shows the version ...");
        StringProperty theString1Arg = CliSugar.stringProperty((String)"string1", (String)"...");
        StringProperty theString2Arg = CliSugar.stringProperty((String)"string2", (String)"...");
        BooleanProperty theboolArg = CliSugar.booleanProperty((String)"bool", (String)"...");
        Flag theBoolFlag = CliSugar.flag((String)"bool", (String)"...");
        StringProperty theEMailArg = CliSugar.stringProperty((String)"email", (String)"...");
        StringProperty theNameArg = CliSugar.stringProperty((String)"name", (String)"...");
        StringProperty theTokenArg = CliSugar.stringProperty((String)"token", (String)"...");
        IntProperty theIntArg = CliSugar.intProperty((String)"int", (String)"...");
        DoubleProperty theDoubleArg = CliSugar.doubleProperty((String)"double", (String)"...");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{theString1Arg, CliSugar.optional((Term[])new Term[]{theString2Arg, CliSugar.xor((Term[])new Term[]{theboolArg, theBoolFlag, CliSugar.and((Term[])new Term[]{theEMailArg, theNameArg, theTokenArg})}), theIntArg, theDoubleArg})}), theHelpFlag, theVersionFlag});
        theParser.withArgsSyntax((Term)theArgsSyntax).withName(null).withSyntaxMetrics(SyntaxNotation.LOGICAL).withEscapeCodesEnabled(false).withConsoleWidth(80).withBannerFontPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withLicense(null).withCopyright(null).withTitle("CROWD:IT").withDescription(null);
        try {
            theParser.evalArgs(theArgs);
            Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
        }
        catch (ArgsSyntaxException e) {
            Operand[] theOperands = ((Condition)theParser.getArgsSyntax()).toOperands(e.getArgs());
            if (IS_LOG_TEST_ENABLED) {
                for (Operand eOperand : theOperands) {
                    System.out.println(eOperand);
                }
            }
            Assertions.assertEquals((int)3, (int)theOperands.length);
            List<Operand> theList = Arrays.asList(theOperands);
            Assertions.assertTrue((boolean)theList.contains(theString1Arg));
            Assertions.assertTrue((boolean)theList.contains(theEMailArg));
            Assertions.assertTrue((boolean)theList.contains(theTokenArg));
        }
    }

    @Test
    public void testEdgeCase1() {
        Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
        StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
        StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
        StringOption thePasswordArg = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
        Term theArgsSyntax = this.createEdgeCaseSyntax(theEncryptFlag, theInputFileArg, theOutputFileArg, thePasswordArg);
        String[] theArgs = new String[]{"-e", "-i", "in.txt", "-o", "out.txt", "-p", "Secret123!"};
        ArgsParser theParser = new ArgsParser(theArgsSyntax);
        try {
            Operand[] theOperands = theParser.evalArgs(theArgs);
            Assertions.assertEquals((int)4, (int)theOperands.length);
        }
        catch (ArgsSyntaxException e) {
            if (IS_LOG_TEST_ENABLED) {
                System.out.println(theArgsSyntax.toSchema());
                System.out.println(e.toHeuristicMessage());
            }
            Assertions.fail((String)"Expecting the arguments syntax to be parsed correctly!");
        }
        Assertions.assertTrue((boolean)theEncryptFlag.isEnabled());
        Assertions.assertEquals((Object)"in.txt", (Object)theInputFileArg.getValue());
        Assertions.assertEquals((Object)"out.txt", (Object)theOutputFileArg.getValue());
        Assertions.assertEquals((Object)"Secret123!", (Object)thePasswordArg.getValue());
    }

    @Test
    public void testEdgeCase2() {
        block3: {
            Flag theEncryptFlag = CliSugar.flag((Character)Character.valueOf('e'), (String)"encrypt", (String)"ENCRYPT_PROPERTY", (String)"Encrypts the message (stream, file, text or bytes).");
            StringOption theInputFileArg = CliSugar.stringOption((Character)Character.valueOf('i'), (String)"input-file", (String)"INPUT_FILE_PROPERTY", (String)"The input file which to process from.");
            StringOption theOutputFileArg = CliSugar.stringOption((Character)Character.valueOf('o'), (String)"output-file", (String)"OUTPUT_FILE_PROPERTY", (String)"The output file which to process to.");
            StringOption thePasswordArg = CliSugar.stringOption((Character)Character.valueOf('p'), (String)"password", (String)"PASSWORD_PROPERTY", (String)"The password to use for encryption or decryption.");
            Term theArgsSyntax = this.createEdgeCaseSyntax(theEncryptFlag, theInputFileArg, theOutputFileArg, thePasswordArg);
            String[] theArgs = new String[]{"-d", "-e", "-i", "in.txt", "-o", "out.txt", "-p", "Secret123!"};
            ArgsParser theParser = new ArgsParser(theArgsSyntax);
            try {
                theParser.evalArgs(theArgs);
                if (IS_LOG_TEST_ENABLED) {
                    System.out.println(theArgsSyntax.toSchema());
                }
                Assertions.fail((String)("Expecting an <" + UnknownArgsException.class.getSimpleName() + ">!"));
            }
            catch (ArgsSyntaxException e) {
                if (!IS_LOG_TEST_ENABLED) break block3;
                System.out.println(e.toHeuristicMessage());
            }
        }
    }

    private Term createEdgeCaseSyntax(Flag aEncryptFlag, StringOption aInputFileArg, StringOption aOutputFileArg, StringOption aPasswordArg) {
        EnumOption theEncodingArg = CliSugar.enumOption((String)"encoding", ArgsParserTest.BaseMetricsConfig.class, (String)"ENCODING_PROPERTY", (String)("The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.BaseMetricsConfig.values())));
        EnumOption theCertModeArg = CliSugar.enumOption((String)"cert-mode", ArgsParserTest.ChaosMode.class, (String)"CERT_MODE_PROPERTY", (String)("The chaos options (mode) to be used for the cert itself: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.ChaosMode.values())));
        EnumOption theChaosModeArg = CliSugar.enumOption((String)"chaos-mode", ArgsParserTest.ChaosMode.class, (String)"CHAOS_MODE_PROPERTY", (String)("The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString((Object[])ArgsParserTest.ChaosMode.values())));
        EnumOption theContextArg = CliSugar.enumOption((String)"context", SystemContext.class, (String)"CONTEXT_PROPERTY", (String)("The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values())));
        Flag theBase64Flag = CliSugar.flag((String)"base64", (String)"BASE64_PROPERTY", (String)"Use BASE64 encoding/decoding to be applied for handling encrypted data.");
        Flag theCertInfoFlag = CliSugar.flag((String)"cert-info", (String)"CERT_INFO_PROPERTY", (String)"Prints out information of a given cert.");
        Flag theCreateCertFlag = CliSugar.flag((String)"create-cert", (String)"CREATE_CERT_PROPERTY", (String)"Create an according cert record (file).");
        Flag theCreateSpecFlag = CliSugar.flag((String)"create-spec", (String)"CREATE_SPEC_PROPERTY", (String)"Create an according spec record (file).");
        DebugFlag theDebugFlag = CliSugar.debugFlag((boolean)false);
        Flag theDecryptFlag = CliSugar.flag((Character)Character.valueOf('d'), (String)"decrypt", (String)"DECRYPT_PROPERTY", (String)"Decrypts the message (stream, file, text or bytes).");
        Flag theEncodedFlag = CliSugar.flag((String)"encoded-length", (String)"ENCODED_LENGTH_PROPERTY", (String)"Prints length in bytes of a single chaos key encoding (being the addional length of a salted encryption).");
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        Flag theHexFlag = CliSugar.flag((String)"hex", (String)"HEX_PROPERTY", (String)"Use a hexadecimal representation of (binary) output.");
        Flag thePromptPasswordFlag = CliSugar.flag((String)"prompt", (String)"PROMPT_PASSWORD_PROPERTY", (String)"Prompt for the password to use for encryption or decryption.");
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag((boolean)false);
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        Flag theVerifyFlag = CliSugar.flag((String)"verify", (String)"VERIFY_PROPERTY", (String)"Verify the encryption process to make sure encryption decrypts flawlessly.");
        Flag theCopyToFlag = CliSugar.flag((String)"copy-to", (String)"COPY_TO_PROPERTY", (String)"Copy the processed output data to the clipboard.");
        Flag thePasteFromFlag = CliSugar.flag((String)"paste-from", (String)"PASTE_FROM_PROPERTY", (String)"Paste the input data to be processed from the clipboard.");
        IntOption theChainLengthArg = CliSugar.intOption((String)"chain-length", (String)"CHAIN_LENGTH_PROPERTY", (String)"The length of the chaos key chain (e.g. number of nested chaos keys, deaults to <...>)");
        IntOption theLineWidthArg = CliSugar.intOption((String)"line-width", (String)"LINE_WIDTH_PROPERTY", (String)"The line width for base64 encoded ASCII output.");
        DoubleOption theX0Arg = CliSugar.doubleOption((Character)Character.valueOf('x'), (String)"start-value", (String)"X0_PROPERTY", (String)"The chaos key's <x0> start value to use: ...");
        DoubleOption theAArg = CliSugar.doubleOption((Character)Character.valueOf('a'), (String)"parable-coefficient", (String)"A_PROPERTY", (String)"The chaos key's parable coefficient <a> to use: ...");
        LongOption theSArg = CliSugar.longOption((Character)Character.valueOf('s'), (String)"expansion-factor", (String)"S_PROPERTY", (String)"The chaos key's expansion factor <s> to use: ...");
        StringOption theBytesArg = CliSugar.stringOption((Character)Character.valueOf('b'), (String)"bytes", (String)"BYTES_PROPERTY", (String)"The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
        StringOption theCertFileArg = CliSugar.stringOption((Character)Character.valueOf('c'), (String)"cert-file", (String)"CERT_FILE_PROPERTY", (String)"The cert file file which to use.");
        StringOption theSpecFileArg = CliSugar.stringOption((String)"spec-file", (String)"SPEC_FILE_PROPERTY", (String)"The spec file file which to use.");
        StringOption theTextArg = CliSugar.stringOption((Character)Character.valueOf('t'), (String)"text", (String)"TEXT_PROPERTY", (String)"The text message which to process.");
        CasesCondition theArgsSyntax = CliSugar.cases((Term[])new Term[]{CliSugar.and((Term[])new Term[]{CliSugar.and((Term[])new Term[]{aEncryptFlag, CliSugar.any((Term[])new Term[]{theVerifyFlag})}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theTextArg, theBytesArg})}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theHexFlag, theBase64Flag, theEncodingArg}), CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg})})})}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theDecryptFlag, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theTextArg, theBytesArg})}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theBase64Flag, theEncodingArg}), theHexFlag, CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg})})})}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.and((Term[])new Term[]{aEncryptFlag, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{aInputFileArg, thePasteFromFlag}), CliSugar.xor((Term[])new Term[]{aOutputFileArg, theCopyToFlag}), CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theBase64Flag, theEncodingArg}), CliSugar.any((Term[])new Term[]{theLineWidthArg})}), theVerifyFlag})}), CliSugar.and((Term[])new Term[]{theDecryptFlag, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{aInputFileArg, thePasteFromFlag}), CliSugar.xor((Term[])new Term[]{aOutputFileArg, theCopyToFlag}), CliSugar.xor((Term[])new Term[]{theBase64Flag, theEncodingArg})})})}), CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg, CliSugar.and((Term[])new Term[]{theX0Arg, theAArg, theSArg})}), theChaosModeArg}), CliSugar.and((Term[])new Term[]{theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg})})})}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theCreateCertFlag, CliSugar.any((Term[])new Term[]{theLineWidthArg, theCertFileArg, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg}), CliSugar.any((Term[])new Term[]{theCertModeArg})}), CliSugar.xor((Term[])new Term[]{CliSugar.or((Term[])new Term[]{theChainLengthArg, theChaosModeArg}), theSpecFileArg}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theCertInfoFlag, theCertFileArg, CliSugar.any((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{thePromptPasswordFlag, aPasswordArg, theContextArg}), theVerboseFlag, theDebugFlag})}), CliSugar.and((Term[])new Term[]{theCreateSpecFlag, CliSugar.any((Term[])new Term[]{theSpecFileArg, theVerboseFlag, theDebugFlag})}), CliSugar.xor((Term[])new Term[]{theHelpFlag, CliSugar.and((Term[])new Term[]{CliSugar.xor((Term[])new Term[]{theEncodedFlag, theSysInfoFlag}), CliSugar.any((Term[])new Term[]{theVerboseFlag, theDebugFlag})})})});
        return theArgsSyntax;
    }
}

